/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.utils;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.CapabilityUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class DelUserFolderDiscoverer
extends DBService {
    public DelUserFolderDiscoverer() {
    }

    public DelUserFolderDiscoverer(DBProvider provider) {
        super(provider);
    }

    public List<FolderObject> discoverFolders(int userId, Context ctx, boolean includeShared) throws OXException {
        int[] accessibleModules;
        ArrayList<FolderObject> discovered = new ArrayList<FolderObject>();
        User user = UserStorage.getInstance().getUser(userId, ctx);
        try {
            accessibleModules = CapabilityUserConfigurationStorage.loadUserConfiguration(userId, ctx).getAccessibleModules();
        }
        catch (OXException e) {
            if (!UserConfigurationCodes.NOT_FOUND.equals(e)) {
                throw e;
            }
            accessibleModules = null;
        }
        Queue<FolderObject> queue = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userId, user.getGroups(), accessibleModules, 8, ctx)).asQueue();
        block2: for (FolderObject fo : queue) {
            if (this.isVirtual(fo)) continue;
            for (OCLPermission perm : fo.getPermissionsAsArray()) {
                if (!includeShared && this.someoneElseMayReadInfoitems(perm, userId)) continue block2;
            }
            discovered.add(fo);
        }
        return discovered;
    }

    private boolean isVirtual(FolderObject fo) {
        int id = fo.getObjectID();
        return id == 15 || id == 10;
    }

    private boolean someoneElseMayReadInfoitems(OCLPermission perm, int userId) {
        return !(!perm.isGroupPermission() && perm.getEntity() == userId || !perm.canReadAllObjects() && !perm.canReadOwnObjects());
    }
}

