/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl.versioncontrol;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlRestored;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlResult;
import com.openexchange.java.Streams;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionControlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VersionControlUtil.class);

    private VersionControlUtil() {
    }

    private static void releaseWriteConnection(Context context, Connection con, boolean afterReading, DBProvider provider) {
        if (afterReading) {
            provider.releaseWriteConnectionAfterReading(context, con);
        } else {
            provider.releaseWriteConnection(context, con);
        }
    }

    private static Map<Integer, DocumentMetadata> asMap(List<DocumentMetadata> documents) {
        if (null == documents) {
            return null;
        }
        HashMap<Integer, DocumentMetadata> m = new HashMap<Integer, DocumentMetadata>(documents.size());
        for (DocumentMetadata document : documents) {
            m.put(document.getId(), document);
        }
        return m;
    }

    private static List<DocumentMetadata> loadVersionsFor(int id, int contextId, Connection con) throws OXException {
        LinkedList<DocumentMetadata> linkedList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT version_number, file_store_location FROM infostore_document WHERE cid=? AND infostore_id=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, id);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<DocumentMetadata> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return list;
        }
        try {
            LinkedList<DocumentMetadata> l = new LinkedList<DocumentMetadata>();
            do {
                String filestoreLocation = rs.getString(2);
                if (rs.wasNull()) continue;
                DocumentMetadataImpl version2 = new DocumentMetadataImpl();
                version2.setId(id);
                version2.setVersion(rs.getInt(1));
                version2.setFilestoreLocation(filestoreLocation);
                l.add(version2);
            } while (rs.next());
            linkedList = l;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return linkedList;
    }

    private static List<Integer> loadDocumentsFromFolder(long folderId, int contextId, Connection con) throws OXException {
        ArrayList<Integer> arrayList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT i.id FROM infostore AS i LEFT JOIN infostore_document AS d ON i.cid=d.cid AND i.id=d.infostore_id WHERE i.cid=? AND i.folder_id=? AND d.file_store_location IS NOT NULL");
            stmt.setInt(1, contextId);
            stmt.setLong(2, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<Integer> list = Collections.emptyList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return list;
        }
        try {
            LinkedHashSet<Integer> documents = new LinkedHashSet<Integer>();
            do {
                documents.add(rs.getInt(1));
            } while (rs.next());
            arrayList = new ArrayList<Integer>(documents);
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    public static Map<Integer, List<VersionControlResult>> changeFileStoreLocationsIfNecessary(int previousOwner, int newOwner, long folderId, Context context, Connection con) throws OXException {
        if (previousOwner == newOwner) {
            return Collections.emptyMap();
        }
        int contextId = context.getContextId();
        QuotaFileStorageService qfs = FileStorages.getQuotaFileStorageService();
        QuotaFileStorage prevFs = qfs.getQuotaFileStorage(previousOwner, contextId);
        QuotaFileStorage newFs = qfs.getQuotaFileStorage(newOwner, contextId);
        if (prevFs.getUri().equals(newFs.getUri())) {
            return Collections.emptyMap();
        }
        List<Integer> documents = VersionControlUtil.loadDocumentsFromFolder(folderId, contextId, con);
        if (documents.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, List<VersionControlResult>> resultMap = new LinkedHashMap<Integer, List<VersionControlResult>>(documents.size());
        for (Integer id : documents) {
            DocumentMetadataImpl document = new DocumentMetadataImpl();
            document.setId(id);
            VersionControlUtil.moveVersions(document, prevFs, newFs, resultMap, context, con);
        }
        if (!resultMap.isEmpty()) {
            VersionControlUtil.applyVersionControl(resultMap, context, con);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<VersionControlResult>> doVersionControl(DBProvider provider, List<DocumentMetadata> documents, List<DocumentMetadata> oldDocuments, long destinationFolder, Context context) throws OXException {
        Map<Integer, List<VersionControlResult>> resultMap = null;
        Connection wcon = provider.getWriteConnection(context);
        try {
            resultMap = VersionControlUtil.doVersionControl(documents, oldDocuments, destinationFolder, context, wcon);
            VersionControlUtil.releaseWriteConnection(context, wcon, null == resultMap || resultMap.isEmpty(), provider);
        }
        catch (Throwable throwable) {
            VersionControlUtil.releaseWriteConnection(context, wcon, null == resultMap || resultMap.isEmpty(), provider);
            throw throwable;
        }
        return resultMap;
    }

    public static Map<Integer, List<VersionControlResult>> doVersionControl(List<DocumentMetadata> documents, List<DocumentMetadata> oldDocuments, long destinationFolder, Context context, Connection con) throws OXException {
        OXFolderAccess folderAccess = new OXFolderAccess(con, context);
        int contextId = context.getContextId();
        QuotaFileStorageService qfs = FileStorages.getQuotaFileStorageService();
        QuotaFileStorage destFs = qfs.getQuotaFileStorage(folderAccess.getFolderOwner((int)destinationFolder), contextId);
        Map<Integer, DocumentMetadata> oldDocs = VersionControlUtil.asMap(oldDocuments);
        LinkedHashMap<Integer, List<VersionControlResult>> resultMap = new LinkedHashMap<Integer, List<VersionControlResult>>(documents.size());
        for (DocumentMetadata document : documents) {
            QuotaFileStorage srcFs;
            Integer id = document.getId();
            DocumentMetadata oldDoc = oldDocs.get(id);
            if (null == oldDoc || (srcFs = qfs.getQuotaFileStorage(folderAccess.getFolderOwner((int)oldDoc.getFolderId()), contextId)).getUri().equals(destFs.getUri())) continue;
            VersionControlUtil.moveVersions(document, srcFs, destFs, resultMap, context, con);
        }
        if (!resultMap.isEmpty()) {
            VersionControlUtil.applyVersionControl(resultMap, context, con);
        }
        return resultMap;
    }

    private static void moveVersions(DocumentMetadata document, QuotaFileStorage srcFs, QuotaFileStorage destFs, Map<Integer, List<VersionControlResult>> resultMap, Context context, Connection con) throws OXException {
        List<DocumentMetadata> versions = VersionControlUtil.loadVersionsFor(document.getId(), context.getContextId(), con);
        LinkedList<VersionControlResult> results = new LinkedList<VersionControlResult>();
        resultMap.put(document.getId(), results);
        for (DocumentMetadata version2 : versions) {
            String copiedLocation;
            InputStream in = null;
            try {
                in = srcFs.getFile(version2.getFilestoreLocation());
                copiedLocation = destFs.saveNewFile(in);
            }
            catch (OXException e) {
                try {
                    for (Map.Entry<Integer, List<VersionControlResult>> documentEntry : resultMap.entrySet()) {
                        Integer documentId = documentEntry.getKey();
                        List<VersionControlResult> versionInfo = documentEntry.getValue();
                        try {
                            VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), context, con);
                        }
                        catch (Exception x) {
                            LOG.error("Failed to restore file storage locations for document {} in context {}", new Object[]{documentId, context.getContextId(), x});
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    Streams.close(in);
                    throw throwable;
                }
            }
            Streams.close((Closeable)in);
            srcFs.deleteFile(version2.getFilestoreLocation());
            results.add(new VersionControlResult(srcFs, destFs, version2.getVersion(), version2.getFilestoreLocation(), copiedLocation));
        }
    }

    private static void applyVersionControl(Map<Integer, List<VersionControlResult>> resultMap, Context context, Connection con) throws OXException {
        PreparedStatement stmt = null;
        boolean error = true;
        try {
            stmt = con.prepareStatement("UPDATE infostore_document SET file_store_location=? WHERE cid=? AND infostore_id=? AND version_number=?");
            int contextId = context.getContextId();
            for (Map.Entry<Integer, List<VersionControlResult>> entry : resultMap.entrySet()) {
                int id = entry.getKey();
                for (VersionControlResult result : entry.getValue()) {
                    stmt.setString(1, result.getDestLocation());
                    stmt.setInt(2, contextId);
                    stmt.setInt(3, id);
                    stmt.setInt(4, result.getVersion());
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
            error = false;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff((Statement)stmt);
                if (error) {
                    for (Map.Entry<Integer, List<VersionControlResult>> documentEntry : resultMap.entrySet()) {
                        Integer documentId = documentEntry.getKey();
                        List<VersionControlResult> versionInfo = documentEntry.getValue();
                        try {
                            VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), context, con);
                        }
                        catch (Exception e2) {
                            LOG.error("Failed to restore file storage locations for document {} in context {}", new Object[]{documentId, context.getContextId(), e2});
                        }
                    }
                }
                throw throwable;
            }
        }
        Databases.closeSQLStuff((Statement)stmt);
        if (error) {
            for (Map.Entry<Integer, List<VersionControlResult>> documentEntry : resultMap.entrySet()) {
                Integer documentId = documentEntry.getKey();
                List<VersionControlResult> versionInfo = documentEntry.getValue();
                try {
                    VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), context, con);
                }
                catch (Exception e) {
                    LOG.error("Failed to restore file storage locations for document {} in context {}", new Object[]{documentId, context.getContextId(), e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<VersionControlRestored>> restoreVersionControl(DBProvider provider, Map<Integer, List<VersionControlResult>> resultMap, Context context) throws OXException {
        Map<Integer, List<VersionControlRestored>> restoredMap = null;
        Connection wcon = provider.getWriteConnection(context);
        try {
            restoredMap = VersionControlUtil.restoreVersionControl(resultMap, context, wcon);
            VersionControlUtil.releaseWriteConnection(context, wcon, null == restoredMap || restoredMap.isEmpty(), provider);
        }
        catch (Throwable throwable) {
            VersionControlUtil.releaseWriteConnection(context, wcon, null == restoredMap || restoredMap.isEmpty(), provider);
            throw throwable;
        }
        return restoredMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<VersionControlRestored>> restoreVersionControl(Map<Integer, List<VersionControlResult>> resultMap, Context context, Connection con) throws OXException {
        LinkedHashMap<Integer, List<VersionControlRestored>> restoredMap = new LinkedHashMap<Integer, List<VersionControlRestored>>(resultMap.size());
        for (Map.Entry<Integer, List<VersionControlResult>> entry : resultMap.entrySet()) {
            Integer id = entry.getKey();
            LinkedList<VersionControlRestored> restoreds = new LinkedList<VersionControlRestored>();
            for (VersionControlResult result : entry.getValue()) {
                String restoredLocation;
                QuotaFileStorage destFs = result.getDestFileStorage();
                InputStream in = null;
                try {
                    in = destFs.getFile(result.getDestLocation());
                    restoredLocation = result.getSourceFileStorage().saveNewFile(in);
                }
                catch (Throwable throwable) {
                    Streams.close(in);
                    throw throwable;
                }
                Streams.close((Closeable)in);
                destFs.deleteFile(result.getDestLocation());
                restoreds.add(new VersionControlRestored(result.getVersion(), restoredLocation));
            }
            restoredMap.put(id, restoreds);
        }
        if (!restoredMap.isEmpty()) {
            VersionControlUtil.applyRestoreds(restoredMap, context, con);
        }
        return restoredMap;
    }

    private static void applyRestoreds(Map<Integer, List<VersionControlRestored>> restoredMap, Context context, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE infostore_document SET file_store_location=? WHERE cid=? AND infostore_id=? AND version_number=?");
            int contextId = context.getContextId();
            for (Map.Entry<Integer, List<VersionControlRestored>> entry : restoredMap.entrySet()) {
                int id = entry.getKey();
                for (VersionControlRestored restored : entry.getValue()) {
                    stmt.setString(1, restored.getLocation());
                    stmt.setInt(2, contextId);
                    stmt.setInt(3, id);
                    stmt.setInt(4, restored.getVersion());
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }
}

