/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.filestore.Filestore;
import com.openexchange.groupware.filestore.FilestoreExceptionCodes;
import com.openexchange.groupware.filestore.FilestoreImpl;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RdbFilestoreStorage
extends FilestoreStorage {
    private static final String SELECT = "SELECT uri, size, max_context FROM filestore WHERE id = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filestore getFilestore(int id) throws OXException {
        Connection con = DBPool.pickup();
        try {
            Filestore filestore = this.getFilestore(con, id);
            return filestore;
        }
        finally {
            DBPool.closeReaderSilent(con);
        }
    }

    @Override
    public Filestore getFilestore(Connection con, int id) throws OXException {
        FilestoreImpl filestoreImpl;
        if (null == con) {
            return this.getFilestore(id);
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT);
            stmt.setInt(1, id);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw FilestoreExceptionCodes.NO_SUCH_FILESTORE.create(Autoboxing.I((int)id));
            }
            FilestoreImpl filestore = new FilestoreImpl();
            filestore.setId(id);
            String tmp = null;
            try {
                tmp = result.getString("uri");
                filestore.setUri(new URI(tmp));
            }
            catch (URISyntaxException e) {
                throw FilestoreExceptionCodes.URI_CREATION_FAILED.create(e, tmp);
            }
            filestore.setSize(result.getLong("size"));
            filestore.setMaxContext(result.getLong("max_context"));
            filestoreImpl = filestore;
        }
        catch (SQLException e) {
            try {
                throw FilestoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return filestoreImpl;
    }
}

