/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.alias.impl;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.alias.UserAliasStorage;
import com.openexchange.groupware.alias.UserAliasStorageExceptionCodes;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class RdbAliasStorage
implements UserAliasStorage {
    @Override
    public void invalidateAliases(int contextId, int userId) throws OXException {
    }

    @Override
    public Set<String> getAliases(int contextId) throws OXException {
        HashSet<String> hashSet;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block6: {
            con = Database.get(contextId, false);
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT alias FROM user_alias WHERE cid=?");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            Set<String> set = Collections.emptySet();
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            return set;
        }
        try {
            LinkedList<String> l = new LinkedList<String>();
            do {
                l.add(rs.getString(1));
            } while (rs.next());
            hashSet = new HashSet<String>(l);
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return hashSet;
    }

    public HashSet<String> getAliases(int contextId, int userId) throws OXException {
        HashSet<String> hashSet;
        Connection con = Database.get(contextId, false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 0;
            stmt = con.prepareStatement("SELECT alias FROM user_alias WHERE cid=? AND user=?");
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            rs = stmt.executeQuery();
            HashSet<String> aliases = new HashSet<String>(6, 0.9f);
            while (rs.next()) {
                aliases.add(rs.getString(1));
            }
            hashSet = aliases;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return hashSet;
    }

    @Override
    public int getUserId(int contextId, String alias) throws OXException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            con = Database.get(contextId, false);
            stmt = null;
            rs = null;
            int index = 0;
            stmt = con.prepareStatement("SELECT user FROM user_alias WHERE cid=? AND LOWER(alias) LIKE LOWER(?) COLLATE utf8_bin");
            stmt.setInt(++index, contextId);
            stmt.setString(++index, alias);
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createAlias(int contextId, int userId, String alias) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            boolean bl = this.createAlias(con, contextId, userId, alias);
            return bl;
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    @Override
    public boolean createAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean bl;
        if (con == null) {
            return this.createAlias(contextId, userId, alias);
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement("INSERT INTO user_alias (cid, user, alias, uuid) VALUES(?,?,?,?)");
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, alias);
            stmt.setBytes(++index, UUIDs.toByteArray((UUID)UUID.randomUUID()));
            bl = stmt.executeUpdate() == 1;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAlias(int contextId, int userId, String oldAlias, String newAlias) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            boolean bl = this.updateAlias(con, contextId, userId, oldAlias, newAlias);
            return bl;
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    @Override
    public boolean updateAlias(Connection con, int contextId, int userId, String oldAlias, String newAlias) throws OXException {
        boolean bl;
        if (con == null) {
            return this.updateAlias(contextId, userId, oldAlias, newAlias);
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement("UPDATE user_alias SET alias=? WHERE cid=? AND user=? AND alias=?");
            stmt.setString(++index, newAlias);
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, oldAlias);
            bl = stmt.executeUpdate() == 1;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteAlias(int contextId, int userId, String alias) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            boolean bl = this.deleteAlias(con, contextId, userId, alias);
            return bl;
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    @Override
    public boolean deleteAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean bl;
        if (con == null) {
            return this.deleteAlias(contextId, userId, alias);
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement("DELETE FROM user_alias WHERE cid=? AND user=? AND alias=?");
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            stmt.setString(++index, alias);
            bl = stmt.executeUpdate() == 1;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteAliases(int contextId, int userId) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            boolean bl = this.deleteAliases(con, contextId, userId);
            return bl;
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    @Override
    public boolean deleteAliases(Connection con, int contextId, int userId) throws OXException {
        boolean bl;
        if (con == null) {
            return this.deleteAliases(contextId, userId);
        }
        PreparedStatement stmt = null;
        try {
            int index = 0;
            stmt = con.prepareStatement("DELETE FROM user_alias WHERE cid=? AND user=?");
            stmt.setInt(++index, contextId);
            stmt.setInt(++index, userId);
            bl = stmt.executeUpdate() != 0;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Integer> getUserIdsByAliasDomain(int contextId, String aliasDomain) throws OXException {
        ArrayList<Integer> arrayList;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = null;
            stmt = null;
            rs = null;
            con = Database.get(contextId, false);
            stmt = con.prepareStatement("SELECT us.id FROM user us LEFT JOIN user_alias la ON us.id = la.user AND us.cid = la.cid WHERE us.cid = ? and la.alias LIKE ?");
            stmt.setInt(1, contextId);
            stmt.setString(2, "%" + aliasDomain);
            rs = stmt.executeQuery();
            if (rs.next()) break block7;
            List<Integer> list = Collections.emptyList();
            DBUtils.closeSQLStuff(rs, stmt);
            Database.back(contextId, false, con);
            return list;
        }
        try {
            ArrayList<Integer> retval = new ArrayList<Integer>();
            do {
                retval.add(rs.getInt(1));
            } while (rs.next());
            arrayList = retval;
        }
        catch (SQLException e) {
            try {
                throw UserAliasStorageExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw UserAliasStorageExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return arrayList;
    }
}

