/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.group.json.actions.AllAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="search", description="Search groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An object with search parameters as described in Group search.", responseDescription="Response with timestamp: An array of group objects as described in Group data.")
public final class SearchAction
extends AbstractGroupAction {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAction.class);

    public SearchAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        if (!req.getSession().getUserPermissionBits().hasGroupware()) {
            return new AJAXRequestResult((Object)new JSONArray(0), "json");
        }
        JSONObject jData = (JSONObject)req.getData();
        if (!jData.hasAndNotNull("pattern")) {
            LOG.warn("Missing field \"{}\" in JSON data. Searching for all as fallback", (Object)"pattern");
            return new AllAction(this.services).perform(req);
        }
        String searchpattern = DataParser.parseString(jData, "pattern");
        ServerSession session = req.getSession();
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = "*".equals(searchpattern) ? groupStorage.getGroups(true, session.getContext()) : groupStorage.searchGroups(searchpattern, true, session.getContext());
        LinkedList<Group> groupList = new LinkedList<Group>();
        Date timestamp = new Date(0L);
        for (int a = 0; a < groups.length; ++a) {
            Group group = groups[a];
            groupList.add(group);
            Date lastModified = group.getLastModified();
            if (null == lastModified || !lastModified.after(timestamp)) continue;
            timestamp = group.getLastModified();
        }
        return new AJAXRequestResult(groupList, timestamp, "group");
    }
}

