/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.SetterAwareFolder;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.internal.FolderStorageRegistry;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPerformer {
    private static final Object PRESENT = new Object();
    protected static final List<ContentType> ALL_ALLOWED = Collections.emptyList();
    protected static final Set<String> KNOWN_TREES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.REAL_TREE_ID, "1")));
    protected final FolderStorageDiscoverer folderStorageDiscoverer;
    protected final ServerSession session;
    protected final User user;
    protected final Context context;
    protected StorageParameters storageParameters;
    private final Map<OXException, Object> warnings;
    protected boolean check4Duplicates;

    protected AbstractPerformer(ServerSession session) throws OXException {
        this(session, FolderStorageRegistry.getInstance());
    }

    protected AbstractPerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        this(session, null, folderStorageDiscoverer);
    }

    protected AbstractPerformer(ServerSession session, StorageParameters storageParameters, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        this.folderStorageDiscoverer = folderStorageDiscoverer;
        this.session = session;
        if (null == session) {
            throw FolderExceptionErrorMessage.INVALID_SESSION.create("Session is null.");
        }
        if (session.getUserId() <= 0 || session.getContextId() <= 0) {
            throw FolderExceptionErrorMessage.INVALID_SESSION.create("Either user and/or context identifier is invalid.");
        }
        this.context = session.getContext();
        if (null == this.context) {
            throw FolderExceptionErrorMessage.INVALID_SESSION.create("Context is null.");
        }
        this.user = session.getUser();
        if (null == this.user) {
            throw FolderExceptionErrorMessage.INVALID_SESSION.create("User is null.");
        }
        this.storageParameters = storageParameters == null ? new StorageParametersImpl(session, this.user, this.context) : storageParameters;
        this.warnings = new ConcurrentHashMap<OXException, Object>(2, 0.9f, 1);
        this.check4Duplicates = true;
    }

    protected AbstractPerformer(User user, Context context) {
        this(user, context, (FolderStorageDiscoverer)FolderStorageRegistry.getInstance());
    }

    protected AbstractPerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        this.folderStorageDiscoverer = folderStorageDiscoverer;
        this.session = null;
        this.user = user;
        this.context = context;
        this.storageParameters = new StorageParametersImpl(user, context);
        this.warnings = new ConcurrentHashMap<OXException, Object>(2, 0.9f, 1);
        this.check4Duplicates = true;
    }

    public void setCheck4Duplicates(boolean check4Duplicates) {
        this.check4Duplicates = check4Duplicates;
    }

    protected void checkOpenedStorage(FolderStorage storage, Collection<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    protected String getContextInfo4Error() {
        Context context = this.context == null ? this.session.getContext() : this.context;
        return null == context ? "" : Integer.toString(context.getContextId());
    }

    protected String getUserInfo4Error() {
        User user = this.user == null ? this.session.getUser() : this.user;
        return null == user ? "" : Integer.toString(user.getId());
    }

    protected String getFolderInfo4Error(Folder folder) {
        return null == folder ? "" : folder.getID();
    }

    protected void addWarning(OXException warning) {
        if (!(Category.CATEGORY_WARNING.equals(warning.getCategory()) || null != warning.getCategories() && warning.getCategories().contains(Category.CATEGORY_WARNING))) {
            warning.addCategory(Category.CATEGORY_WARNING);
        }
        this.warnings.put(warning, PRESENT);
    }

    public int getNumOfWarnings() {
        return this.warnings.size();
    }

    public Set<OXException> getWarnings() {
        return Collections.unmodifiableSet(this.warnings.keySet());
    }

    protected StorageParameters newStorageParameters() {
        if (null == this.session) {
            return new StorageParametersImpl(this.user, this.context);
        }
        return new StorageParametersImpl(this.session, this.user, this.context);
    }

    protected FolderStorage getOpenedStorage(String id, String treeId, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage ps : openedStorages) {
            if (!ps.getFolderType().servesFolderId(id)) continue;
            return ps;
        }
        FolderStorage tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
        if (null == tmp) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
        }
        if (tmp.startTransaction(storageParameters, false)) {
            openedStorages.add(tmp);
        }
        return tmp;
    }

    protected void checkOpenedStorage(FolderStorage checkMe, boolean modify, Collection<FolderStorage> openedStorages) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(this.storageParameters, modify)) {
            openedStorages.add(checkMe);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public int getContextId() {
        return this.context.getContextId();
    }

    public void setStorageParameters(StorageParameters storageParameters) {
        this.storageParameters = storageParameters;
    }

    public StorageParameters getStorageParameters() {
        return this.storageParameters;
    }

    public User getUser() {
        return this.user;
    }

    public int getUserId() {
        return this.user.getId();
    }

    public ServerSession getSession() {
        return this.session;
    }

    public FolderStorageDiscoverer getFolderStorageDiscoverer() {
        return this.folderStorageDiscoverer;
    }

    protected static final class UpdateFolder
    extends AbstractFolder
    implements SetterAwareFolder {
        private static final long serialVersionUID = -6666991788068206301L;
        private boolean containsSubscribed = false;

        @Override
        public boolean isGlobalID() {
            return false;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean containsSubscribed() {
            return this.containsSubscribed;
        }

        @Override
        public void setSubscribed(boolean subscribed) {
            super.setSubscribed(subscribed);
            this.containsSubscribed = true;
        }
    }
}

