/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Permissions;

public class DefaultPermission
implements Permission {
    private static final long serialVersionUID = -5218844055549055552L;
    private int entity = -1;
    private boolean group;
    private int system;
    private boolean admin;
    private int folderPermission;
    private int readPermission;
    private int writePermission;
    private int deletePermission;

    public DefaultPermission() {
        this.setNoPermissions();
    }

    public DefaultPermission(int entity, boolean isGroup, int permissionBits) {
        this.entity = entity;
        this.group = isGroup;
        int[] permissions = Permissions.parsePermissionBits(permissionBits);
        this.folderPermission = permissions[0];
        this.readPermission = permissions[1];
        this.writePermission = permissions[2];
        this.deletePermission = permissions[3];
        this.admin = permissions[4] > 0;
    }

    public DefaultPermission(Permission permission) {
        this.entity = permission.getEntity();
        this.group = permission.isGroup();
        this.system = permission.getSystem();
        this.admin = permission.isAdmin();
        this.folderPermission = permission.getFolderPermission();
        this.readPermission = permission.getReadPermission();
        this.writePermission = permission.getWritePermission();
        this.deletePermission = permission.getDeletePermission();
    }

    @Override
    public boolean isVisible() {
        return this.isAdmin() || this.getFolderPermission() > 0;
    }

    @Override
    public int getDeletePermission() {
        return this.deletePermission;
    }

    @Override
    public int getEntity() {
        return this.entity;
    }

    @Override
    public int getFolderPermission() {
        return this.folderPermission;
    }

    @Override
    public int getReadPermission() {
        return this.readPermission;
    }

    @Override
    public int getSystem() {
        return this.system;
    }

    @Override
    public int getWritePermission() {
        return this.writePermission;
    }

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    @Override
    public void setAllPermissions(int folderPermission, int readPermission, int writePermission, int deletePermission) {
        this.folderPermission = folderPermission;
        this.readPermission = readPermission;
        this.deletePermission = deletePermission;
        this.writePermission = writePermission;
    }

    @Override
    public void setDeletePermission(int permission) {
        this.deletePermission = permission;
    }

    @Override
    public void setEntity(int entity) {
        this.entity = entity;
    }

    @Override
    public void setFolderPermission(int permission) {
        this.folderPermission = permission;
    }

    @Override
    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public void setMaxPermissions() {
        this.folderPermission = 128;
        this.readPermission = 128;
        this.deletePermission = 128;
        this.writePermission = 128;
        this.admin = true;
    }

    @Override
    public void setNoPermissions() {
        this.folderPermission = 0;
        this.readPermission = 0;
        this.deletePermission = 0;
        this.writePermission = 0;
        this.admin = false;
    }

    @Override
    public void setReadPermission(int permission) {
        this.readPermission = permission;
    }

    @Override
    public void setSystem(int system) {
        this.system = system;
    }

    @Override
    public void setWritePermission(int permission) {
        this.writePermission = permission;
    }

    @Override
    public Object clone() {
        return new DefaultPermission(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.admin ? 1231 : 1237);
        result = 31 * result + this.deletePermission;
        result = 31 * result + this.entity;
        result = 31 * result + this.folderPermission;
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.readPermission;
        result = 31 * result + this.system;
        result = 31 * result + this.writePermission;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.admin != other.isAdmin()) {
            return false;
        }
        if (this.deletePermission != other.getDeletePermission()) {
            return false;
        }
        if (this.entity != other.getEntity()) {
            return false;
        }
        if (this.folderPermission != other.getFolderPermission()) {
            return false;
        }
        if (this.group != other.isGroup()) {
            return false;
        }
        if (this.readPermission != other.getReadPermission()) {
            return false;
        }
        if (this.system != other.getSystem()) {
            return false;
        }
        return this.writePermission == other.getWritePermission();
    }

    public String toString() {
        return "DefaultPermission [entity=" + this.entity + ", group=" + this.group + ", admin=" + this.admin + ", system=" + this.system + ", folderPermission=" + this.folderPermission + ", readPermission=" + this.readPermission + ", writePermission=" + this.writePermission + ", deletePermission=" + this.deletePermission + "]";
    }
}

