/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folder.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folder.FolderService;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import java.sql.Connection;
import java.sql.SQLException;

public final class FolderServiceImpl
implements FolderService {
    private static final String DEL_OXFOLDER_TREE = "del_oxfolder_tree";
    private static final String DEL_OXFOLDER_PERMISSIONS = "del_oxfolder_permissions";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject getFolderObject(int folderId, int contextId) throws OXException {
        try {
            return new OXFolderAccess(ContextStorage.getStorageContext(contextId)).getFolderObject(folderId);
        }
        catch (OXException e) {
            if (!OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                throw e;
            }
            Context ctx = ContextStorage.getStorageContext(contextId);
            Connection con = Database.get(ctx, false);
            try {
                FolderObject folderObject = OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, con, true, false, DEL_OXFOLDER_TREE, DEL_OXFOLDER_PERMISSIONS);
                return folderObject;
            }
            finally {
                Database.back(ctx, false, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject getFolderObject(int folderId, int contextId, boolean working) throws OXException {
        if (working) {
            return new OXFolderAccess(ContextStorage.getStorageContext(contextId)).getFolderObject(folderId);
        }
        Context ctx = ContextStorage.getStorageContext(contextId);
        Connection con = Database.get(ctx, false);
        try {
            FolderObject folderObject = OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, con, true, false, DEL_OXFOLDER_TREE, DEL_OXFOLDER_PERMISSIONS);
            return folderObject;
        }
        finally {
            Database.back(ctx, false, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject getFolderObject(int folderId, int contextId, FolderService.Storage storage) throws OXException {
        if (FolderService.Storage.WORKING.equals((Object)storage)) {
            return new OXFolderAccess(ContextStorage.getStorageContext(contextId)).getFolderObject(folderId);
        }
        Context ctx = ContextStorage.getStorageContext(contextId);
        if (FolderService.Storage.BACKUP.equals((Object)storage)) {
            Connection con = Database.get(ctx, false);
            try {
                FolderObject folderObject = OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, con, true, false, DEL_OXFOLDER_TREE, DEL_OXFOLDER_PERMISSIONS);
                return folderObject;
            }
            finally {
                Database.back(ctx, false, con);
            }
        }
        Connection con = Database.get(ctx, true);
        try {
            String table = FolderService.Storage.LIVE_BACKUP.equals((Object)storage) ? DEL_OXFOLDER_TREE : "oxfolder_tree";
            String permTable = FolderService.Storage.LIVE_BACKUP.equals((Object)storage) ? DEL_OXFOLDER_PERMISSIONS : "oxfolder_permissions";
            FolderObject folderObject = OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, con, true, false, table, permTable);
            return folderObject;
        }
        finally {
            Database.back(ctx, true, con);
        }
    }

    @Override
    public EffectivePermission getFolderPermission(int folderId, int userId, int contextId) throws OXException {
        try {
            return this.getFolderPermission(folderId, userId, contextId, true);
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                return this.getFolderPermission(folderId, userId, contextId, false);
            }
            throw e;
        }
    }

    @Override
    public EffectivePermission getFolderPermission(int folderId, int userId, int contextId, boolean working) throws OXException {
        Context ctx = ContextStorage.getStorageContext(contextId);
        UserPermissionBits permissionBits = UserPermissionBitsStorage.getInstance().getUserPermissionBits(userId, ctx);
        if (working) {
            return new OXFolderAccess(ctx).getFolderPermission(folderId, userId, permissionBits);
        }
        Connection con = Database.get(ctx, false);
        try {
            FolderObject delFolder = OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, con, true, false, DEL_OXFOLDER_TREE, DEL_OXFOLDER_PERMISSIONS);
            EffectivePermission effectivePermission = delFolder.getEffectiveUserPermission(userId, permissionBits, con);
            return effectivePermission;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            Database.back(ctx, false, con);
        }
    }
}

