/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import java.util.concurrent.atomic.AtomicReference;

public class ConsistencyServiceLookup {
    private static final AtomicReference<ServiceLookup> ref = new AtomicReference();

    public static ServiceLookup get() {
        return ref.get();
    }

    public static void set(ServiceLookup serviceLookup) {
        ref.set(serviceLookup);
    }

    public static <S> S getService(Class<? extends S> c) throws OXException {
        return ConsistencyServiceLookup.getService(c, false);
    }

    public static <S> S getService(Class<? extends S> c, boolean throwOnAbsence) throws OXException {
        Object service;
        ServiceLookup serviceLookup = ref.get();
        Object object = service = null == serviceLookup ? null : serviceLookup.getService(c);
        if (null == service && throwOnAbsence) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{c.getName()});
        }
        return (S)service;
    }

    public static <S> S getOptionalService(Class<? extends S> c) {
        ServiceLookup serviceLookup = ref.get();
        Object service = null == serviceLookup ? null : serviceLookup.getOptionalService(c);
        return (S)service;
    }
}

