/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.remote;

import com.openexchange.cache.remote.FolderCacheInvalidation;
import com.openexchange.cache.remote.GenericCacheInvalidationInterface;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCacheAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCacheAdmin.class);
    private static final int REGISTRY_PORT = 57462;
    private static volatile RemoteCacheAdmin instance;
    private static final AtomicBoolean initialized;
    private final Registry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startRemoteCacheAdmin() {
        if (!initialized.get()) {
            AtomicBoolean atomicBoolean = initialized;
            synchronized (atomicBoolean) {
                if (instance == null) {
                    try {
                        instance = new RemoteCacheAdmin();
                        initialized.set(true);
                    }
                    catch (RemoteException e) {
                        LOG.error("", (Throwable)e);
                    }
                    catch (AlreadyBoundException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    public static void main(String[] args) {
        RemoteCacheAdmin.startRemoteCacheAdmin();
    }

    private RemoteCacheAdmin() throws RemoteException, AlreadyBoundException {
        LocateRegistry.createRegistry(57462);
        GenericCacheInvalidationInterface gci = (GenericCacheInvalidationInterface)UnicastRemoteObject.exportObject((Remote)new FolderCacheInvalidation(), 0);
        this.registry = LocateRegistry.getRegistry(57462);
        this.registry.bind(gci.getRemoteName(), gci);
        LOG.info("RemoteCacheAdmin started...");
    }

    static {
        initialized = new AtomicBoolean();
    }
}

