/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.api2.sync;

import com.openexchange.api2.sync.FolderSyncInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import java.util.Date;

public class RdbFolderSyncInterface
implements FolderSyncInterface {
    private final int userId;
    private final Context ctx;
    private final Session session;
    private final User user;
    private final OXFolderAccess oxfolderAccess;
    private final UserConfiguration userConfiguration;

    public RdbFolderSyncInterface(Session sessionObj, Context ctx) throws OXException {
        this(sessionObj, ctx, null);
    }

    public RdbFolderSyncInterface(Session session, Context ctx, OXFolderAccess oxfolderAccess) throws OXException {
        this.session = session;
        this.user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
        this.userId = this.user.getId();
        this.user.getGroups();
        this.ctx = ctx;
        this.oxfolderAccess = oxfolderAccess == null ? new OXFolderAccess(ctx) : oxfolderAccess;
        this.userConfiguration = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), ctx);
    }

    @Override
    public int clearFolder(FolderObject folder, Date clientLastModified) throws OXException {
        try {
            if (folder.getType() == 2 && !this.userConfiguration.hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), folder.getObjectID(), this.ctx.getContextId());
            }
            if (!folder.exists(this.ctx)) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folder.getObjectID(), this.ctx.getContextId());
            }
            if (clientLastModified != null && this.oxfolderAccess.getFolderLastModified(folder.getObjectID()).after(clientLastModified)) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folder.getObjectID(), this.ctx.getContextId());
            }
            EffectivePermission effectivePerm = folder.getEffectiveUserPermission(this.userId, this.userConfiguration);
            if (!effectivePerm.hasModuleAccess(folder.getModule())) {
                throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(this.session.getUserId(), OXFolderUtility.folderModule2String(folder.getModule()), this.ctx.getContextId());
            }
            if (!effectivePerm.isFolderVisible()) {
                if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folder.getObjectID(), this.session.getUserId(), this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.NOT_VISIBLE.create(folder.getObjectID(), this.session.getUserId(), this.ctx.getContextId());
            }
            long lastModified = System.currentTimeMillis();
            OXFolderManager.getInstance(this.session, this.oxfolderAccess).clearFolder(folder, false, lastModified);
            return folder.getObjectID();
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }
}

