/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.services.ServerServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixServiceActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void startBundle() throws Exception {
        try {
            DefaultDispatcherPrefixService prefixService = new DefaultDispatcherPrefixService(this.loadPrefix());
            ServerServiceRegistry.getInstance().addService(DispatcherPrefixService.class, prefixService);
            ImageMatcher.setPrefixService(prefixService);
            this.registerService(DispatcherPrefixService.class, prefixService);
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(PrefixServiceActivator.class);
            log.error("DispatcherPrefixService could not be registered", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            Logger log = LoggerFactory.getLogger(PrefixServiceActivator.class);
            log.error("DispatcherPrefixService could not be registered", (Throwable)e);
            throw e;
        }
    }

    private String loadPrefix() {
        String prefix = ((ConfigurationService)this.getService(ConfigurationService.class)).getProperty("com.openexchange.dispatcher.prefix", "/ajax/").trim();
        if (prefix.charAt(0) != '/') {
            prefix = '/' + prefix;
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        return prefix;
    }
}

