/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.cache.AbstractResourceCache;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.FileStorageCodes;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceLookup;
import com.openexchange.timer.TimerService;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreResourceCacheImpl
extends AbstractResourceCache {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreResourceCacheImpl.class);
    protected static long ALIGNMENT_DELAY = 10000L;
    private final boolean quotaAware;
    private static final Object SCHEDULED = new Object();
    private static final Object RUNNING = new Object();
    private final ConcurrentMap<Integer, Object> alignmentRequests = new ConcurrentHashMap<Integer, Object>();

    private static FileStorage getFileStorage(int contextId, boolean quotaAware) throws OXException {
        QuotaFileStorageService qfss = FileStorages.getQuotaFileStorageService();
        if (quotaAware) {
            return qfss.getQuotaFileStorage(contextId);
        }
        URI uri = qfss.getFileStorageUriFor(0, contextId);
        return FileStorages.getFileStorageService().getFileStorage(uri);
    }

    public FileStoreResourceCacheImpl(ServiceLookup serviceLookup) throws OXException {
        super(serviceLookup);
        this.quotaAware = this.getConfigurationService().getBoolProperty("com.openexchange.preview.cache.quotaAware", false);
    }

    private void batchDeleteFiles(Collection<String> ids, FileStorage fileStorage) {
        block5: {
            try {
                Set notDeleted = fileStorage.deleteFiles(ids.toArray(new String[0]));
                if (notDeleted.isEmpty()) break block5;
                LOG.warn("Some cached files could not be deleted from filestore. Consider using 'checkconsistency' to clean up manually.");
            }
            catch (Exception e) {
                LOG.warn("Error while deleting a batch of preview files. Trying one-by-one now...", (Throwable)e);
                for (String id : ids) {
                    if (null == id) continue;
                    try {
                        fileStorage.deleteFile(id);
                    }
                    catch (Exception x) {
                        LOG.warn("Could not remove preview file '{}'. Consider using 'checkconsistency' to clean up the filestore.", (Object)id, (Object)x);
                    }
                }
            }
        }
    }

    @Override
    public boolean save(String id, CachedResource resource, int userId, int contextId) throws OXException {
        InputStream in = resource.getInputStream();
        DataProvider dataProvider = null == in ? new ByteArrayDataProvider(resource.getBytes()) : new StreamingDataProvider(in);
        return this.save(id, dataProvider, resource.getFileName(), resource.getFileType(), userId, contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(String id, DataProvider dataProvider, String optName, String optType, int userId, int contextId) throws OXException {
        block47: {
            LOG.debug("Trying to cache resource {}.", (Object)id);
            ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
            FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
            DatabaseService dbService = this.getDBService();
            long globalQuota = this.getGlobalQuota(userId, contextId);
            if (this.fitsQuotas(dataProvider.getSize(), globalQuota, userId, contextId)) {
                String refId = fileStorage.saveNewFile(dataProvider.getStream());
                ResourceCacheMetadata newMetadata = new ResourceCacheMetadata();
                newMetadata.setContextId(contextId);
                newMetadata.setUserId(userId);
                newMetadata.setResourceId(id);
                newMetadata.setFileName(this.prepareFileName(optName));
                newMetadata.setFileType(this.prepareFileType(optType));
                newMetadata.setSize(dataProvider.getSize());
                newMetadata.setCreatedAt(System.currentTimeMillis());
                newMetadata.setRefId(refId);
                Connection con = dbService.getWritable(contextId);
                ResourceCacheMetadata existingMetadata = null;
                boolean committed = false;
                boolean triggerAlignment = false;
                long start = System.currentTimeMillis();
                try {
                    long usedSize22;
                    Databases.startTransaction((Connection)con);
                    if (FileStoreResourceCacheImpl.entryExists(metadataStore, con, contextId, userId, id)) {
                        existingMetadata = FileStoreResourceCacheImpl.loadExistingEntryForUpdate(metadataStore, con, contextId, userId, id);
                        if (existingMetadata == null) {
                            metadataStore.store(con, newMetadata);
                        } else {
                            metadataStore.update(con, newMetadata);
                        }
                    } else {
                        metadataStore.store(con, newMetadata);
                    }
                    if (globalQuota > 0L && (usedSize22 = metadataStore.getUsedSize(con, contextId)) > globalQuota) {
                        triggerAlignment = true;
                    }
                    con.commit();
                    committed = true;
                    boolean usedSize22 = true;
                    return usedSize22;
                }
                catch (DataTruncation e) {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (SQLIntegrityConstraintViolationException e) {
                    long transactionDuration = System.currentTimeMillis() - start;
                    LOG.warn("Caching a resource failed due to a duplicate key conflict, this should happen very rarely otherwise this may indicate a performance problem. The transaction lasted {}ms. Original message: {}.", (Object)transactionDuration, (Object)e.getMessage());
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1022) {
                        long transactionDuration = System.currentTimeMillis() - start;
                        LOG.warn("Caching a resource failed due to a duplicate key conflict, this should happen very rarely otherwise this may indicate a performance problem. The transaction lasted {}ms. Original message: {}.", (Object)transactionDuration, (Object)e.getMessage());
                        break block47;
                    }
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    if (committed) {
                        Databases.autocommit((Connection)con);
                        dbService.backWritable(contextId, con);
                        if (existingMetadata != null) {
                            try {
                                if (!fileStorage.deleteFile(existingMetadata.getRefId())) {
                                    LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId());
                                }
                            }
                            catch (OXException e) {
                                LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId(), (Object)e);
                            }
                        }
                        if (triggerAlignment && this.alignmentRequests.putIfAbsent(contextId, SCHEDULED) == null && this.scheduleAlignmentTask(globalQuota, contextId)) {
                            LOG.debug("Scheduling alignment task for context {}.", (Object)contextId);
                        } else {
                            LOG.debug("Skipping scheduling of alignment task for context {}.", (Object)contextId);
                        }
                    } else {
                        if (con != null) {
                            try {
                                con.rollback();
                            }
                            catch (SQLException e) {
                                LOG.warn("Could not rollback database transaction after failing to cache a resource. Consider using 'checkconsistency' to clean up the database.");
                            }
                            Databases.autocommit((Connection)con);
                            dbService.backWritableAfterReading(contextId, con);
                        }
                        try {
                            if (refId != null && !fileStorage.deleteFile(refId)) {
                                LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId);
                            }
                        }
                        catch (OXException e) {
                            LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId, (Object)e);
                        }
                    }
                }
            }
        }
        return false;
    }

    protected boolean scheduleAlignmentTask(final long globalQuota, final int contextId) {
        try {
            TimerService timerService = this.optTimerService();
            if (timerService != null) {
                timerService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        FileStoreResourceCacheImpl.this.alignToQuota(globalQuota, contextId);
                    }
                }, ALIGNMENT_DELAY);
                return true;
            }
        }
        catch (RejectedExecutionException e) {
            Integer iContextId = contextId;
            this.alignmentRequests.remove(iContextId);
            LOG.warn("Could not schedule alignment task for context {}.", (Object)iContextId, (Object)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alignToQuota(long globalQuota, int contextId) {
        Integer iContextId = contextId;
        if (!this.alignmentRequests.replace(iContextId, SCHEDULED, RUNNING)) {
            return;
        }
        try {
            ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
            DatabaseService dbService = this.getDBService();
            Connection con = dbService.getWritable(contextId);
            HashSet<String> refIds = new HashSet<String>();
            boolean transactionStarted = false;
            boolean rollback = false;
            try {
                long usedContextQuota = metadataStore.getUsedSize(con, contextId);
                if (globalQuota > 0L && usedContextQuota > globalQuota) {
                    ResourceCacheMetadata metadata;
                    long neededSpace = usedContextQuota - globalQuota;
                    Databases.startTransaction((Connection)con);
                    transactionStarted = true;
                    rollback = true;
                    List<ResourceCacheMetadata> entries = metadataStore.loadForCleanUp(con, contextId);
                    Iterator<ResourceCacheMetadata> it = entries.iterator();
                    for (long collected = 0L; collected < neededSpace && it.hasNext(); collected += metadata.getSize() > 0L ? metadata.getSize() : 0L) {
                        metadata = it.next();
                        String refId = metadata.getRefId();
                        if (refId == null) continue;
                        refIds.add(refId);
                    }
                    if (!refIds.isEmpty()) {
                        metadataStore.removeByRefIds(con, contextId, refIds);
                    }
                    con.commit();
                    rollback = false;
                }
            }
            catch (SQLException s) {
                LOG.error("Could not align preview cache for context {} to quota.", (Object)iContextId, (Object)s);
            }
            finally {
                if (rollback) {
                    Databases.rollback((Connection)con);
                }
                this.alignmentRequests.remove(iContextId);
                if (transactionStarted) {
                    Databases.autocommit((Connection)con);
                }
                if (refIds.isEmpty()) {
                    dbService.backWritableAfterReading(contextId, con);
                } else {
                    dbService.backWritable(contextId, con);
                }
            }
            if (refIds.isEmpty()) {
                LOG.debug("No need to align preview cache for context {} to quota.", (Object)iContextId);
            } else {
                LOG.debug("Aligning preview cache for context {} to quota.", (Object)iContextId);
                this.batchDeleteFiles(refIds, FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware));
            }
        }
        catch (Exception e) {
            LOG.error("Could not align preview cache for context {} to quota.", (Object)iContextId, (Object)e);
        }
    }

    @Override
    public void remove(int userId, int contextId) throws OXException {
        this.remove0(userId, contextId);
    }

    @Override
    public void clearFor(int contextId) throws OXException {
        this.remove0(-1, contextId);
    }

    private void remove0(int userId, int contextId) throws OXException {
        long start = System.currentTimeMillis();
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        this.batchDeleteFiles(refIds, fileStorage);
        LOG.info("Cleared resource cache for user {} in context {} in {}ms.", new Object[]{userId, contextId, System.currentTimeMillis() - start});
    }

    @Override
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        if (null == id) {
            throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId, id);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        this.batchDeleteFiles(refIds, fileStorage);
    }

    @Override
    public CachedResource get(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return null;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return null;
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        try {
            InputStream file = fileStorage.getFile(metadata.getRefId());
            return new CachedResource(file, metadata.getFileName(), metadata.getFileType(), metadata.getSize());
        }
        catch (OXException e) {
            if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                throw e;
            }
            metadataStore.remove(contextId, userId, id);
            return null;
        }
    }

    @Override
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return false;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        try {
            Streams.close((Closeable)fileStorage.getFile(metadata.getRefId()));
        }
        catch (OXException e) {
            if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                throw e;
            }
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        return true;
    }

    private boolean fitsQuotas(long desiredSize, long globalQuota, int userId, int contextId) throws OXException {
        long documentQuota = this.getDocumentQuota(userId, contextId);
        if (globalQuota > 0L || documentQuota > 0L) {
            if (globalQuota <= 0L) {
                return documentQuota <= 0L || desiredSize <= documentQuota;
            }
            if (desiredSize > globalQuota || desiredSize > documentQuota) {
                return false;
            }
        }
        return true;
    }

    private static class StreamingDataProvider
    implements DataProvider {
        private final ThresholdFileHolder sink;

        StreamingDataProvider(InputStream in) throws OXException {
            ThresholdFileHolder sink = new ThresholdFileHolder();
            sink.write(in);
            this.sink = sink;
        }

        @Override
        public InputStream getStream() throws OXException {
            return this.sink.getClosingStream();
        }

        @Override
        public long getSize() {
            return this.sink.getLength();
        }
    }

    private static class ByteArrayDataProvider
    implements DataProvider {
        private final byte[] bytes;

        ByteArrayDataProvider(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public InputStream getStream() {
            return Streams.newByteArrayInputStream((byte[])this.bytes);
        }

        @Override
        public long getSize() {
            return this.bytes.length;
        }
    }

    private static interface DataProvider {
        public InputStream getStream() throws OXException;

        public long getSize();
    }
}

