/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.printing.converter;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.templating.TemplateErrorMessage;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class Request {
    private final Dispatcher dispatcher;
    private final ServerSession session;
    private final boolean trusted;
    private String action;
    private String module;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Object body;

    public Request(Dispatcher dispatcher, ServerSession session, boolean trusted) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.trusted = trusted;
    }

    public Request action(String action) {
        this.action = action;
        return this;
    }

    public Request module(String module) {
        this.module = module;
        return this;
    }

    public Request param(String name, Object value) {
        this.parameters.put(name, value.toString());
        return this;
    }

    public Request body(Object body) {
        this.body = body;
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object perform() throws OXException {
        Object object;
        if (!this.trusted) {
            throw TemplateErrorMessage.AccessDenied.create();
        }
        AJAXRequestData req = new AJAXRequestData();
        req.setHostname("localhost");
        req.setAction(this.action);
        req.setServletRequestURI("");
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            req.putParameter(param.getKey(), param.getValue());
        }
        req.setModule(this.module);
        try {
            req.setData(JSONCoercion.coerceToJSON(this.body));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e.toString());
        }
        AJAXState state = null;
        AJAXRequestResult result = null;
        Throwable exc = null;
        try {
            state = this.dispatcher.begin();
            req.setFormat("native");
            result = this.dispatcher.perform(req, state, ServerSessionAdapter.valueOf(this.session));
            object = result.getResultObject();
        }
        catch (OXException e) {
            try {
                exc = e;
                throw e;
                catch (RuntimeException e2) {
                    exc = e2;
                    throw OXException.general((String)e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                Dispatchers.signalDone(result, (Exception)exc);
                this.dispatcher.end(state);
                throw throwable;
            }
        }
        Dispatchers.signalDone(result, (Exception)exc);
        this.dispatcher.end(state);
        return object;
    }
}

