/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.osgi;

import com.openexchange.osgi.HousekeepingActivator;
import java.util.Dictionary;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServletActivator
extends HousekeepingActivator {
    private final Queue<String> servlets = new ConcurrentLinkedQueue<String>();

    protected AbstractServletActivator() {
    }

    protected boolean registerServlet(String alias, HttpServlet servlet, HttpService httpService) {
        return this.registerServlet(alias, servlet, null, httpService);
    }

    protected boolean registerServlet(String alias, HttpServlet servlet, Dictionary<String, String> params, HttpService httpService) {
        try {
            httpService.registerServlet(alias, (Servlet)servlet, params, null);
            this.servlets.offer(alias);
            return true;
        }
        catch (ServletException e) {
            Logger logger = LoggerFactory.getLogger(AbstractServletActivator.class);
            logger.error("", (Throwable)e);
        }
        catch (NamespaceException e) {
            Logger logger = LoggerFactory.getLogger(AbstractServletActivator.class);
            logger.error("", (Throwable)e);
        }
        return false;
    }

    protected void cleanUp() {
        this.unregisterServlets();
        super.cleanUp();
    }

    private void unregisterServlets() {
        HttpService httpService = (HttpService)this.getService(HttpService.class);
        if (null != httpService) {
            for (String alias : this.servlets) {
                try {
                    httpService.unregister(alias);
                }
                catch (Exception e) {
                    Logger logger = LoggerFactory.getLogger(AbstractServletActivator.class);
                    logger.warn("Failed to unregister servlet alias: {}", (Object)alias, (Object)e);
                }
            }
            this.servlets.clear();
        }
    }

    protected void unregisterServlet(String alias) {
        HttpService httpService;
        if (this.servlets.remove(alias) && null != (httpService = (HttpService)this.getService(HttpService.class))) {
            httpService.unregister(alias);
        }
    }
}

