/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.html.SimHtmlService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.sim.SimHttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ToolsTest {
    private static final String QUERY_STRING_WITHOUT_PASSWORD = "action=autologin&client=open-xchange-appsuite&rampup=true&rampupFor=open-xchange-appsuite&version=7.8.0-0";
    private static final String QUERY_STRING_WITH_PASSWORD = "action=autologin&client=open-xchange-appsuite&rampup=true&rampupFor=open-xchange-appsuite&version=7.8.0-0&password=schalke04IsDerGeilsteVereinDerWelt";
    private SimHttpServletRequest request;
    @Mock
    private ConfigurationService configurationService;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.configurationService.getBoolProperty("com.openexchange.check.url.params", true)).thenReturn((Object)Boolean.TRUE);
        Tools.setConfigurationService((ConfigurationService)this.configurationService);
        this.request = new SimHttpServletRequest();
        this.request.setQueryString(QUERY_STRING_WITHOUT_PASSWORD);
    }

    @Test
    public void testCheckNonExistence_requestNull_doNothing() throws OXException {
        Tools.checkNonExistence(null, (String[])new String[]{"password"});
    }

    @Test
    public void testCheckNonExistence_paramNull_doNothing() throws OXException {
        Tools.checkNonExistence((HttpServletRequest)this.request, null);
    }

    @Test
    public void testCheckNonExistence_nonNotAllowedFiled_doNothing() throws OXException {
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"password"});
    }

    @Test(expected=OXException.class)
    public void testCheckNonExistence_containsNotAllowedField_throwException() throws OXException {
        this.request.setQueryString(QUERY_STRING_WITH_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"password"});
    }

    @Test
    public void testCheckNonExistence_passwordInParamList_ignore() throws OXException {
        this.request.setParameter("password", "meinPassword");
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"password"});
    }

    @Test
    public void testCheckNonExistence_queryStringNull_ignore() throws OXException {
        this.request.setQueryString(null);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"password"});
    }

    @Test(expected=OXException.class)
    public void testCheckNonExistence_multipleParamsWithNotAllowedField_throwException() throws OXException {
        this.request.setQueryString(QUERY_STRING_WITH_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "version", "password", "session"});
    }

    @Test(expected=OXException.class)
    public void testCheckNonExistence_multipleParamsAndNotAllowedFieldIncluded_throwException() throws OXException {
        this.request.setQueryString(QUERY_STRING_WITH_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "version", "password", "session"});
    }

    @Test(expected=OXException.class)
    public void testCheckNonExistence_multipleParamsAndVersionNotAllowed_throwException() throws OXException {
        this.request.setQueryString(QUERY_STRING_WITHOUT_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "version", "password", "session"});
    }

    @Test
    public void testCheckNonExistence_multipleParamsAndVersionNotAllowed_containsAllWrongParams() {
        this.request.setQueryString(QUERY_STRING_WITH_PASSWORD);
        try {
            Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "version", "password", "session"});
        }
        catch (Exception e) {
            Assert.assertTrue((String)"", (boolean)e.getMessage().contains("version"));
            Assert.assertTrue((String)"", (boolean)e.getMessage().contains("password"));
        }
    }

    @Test
    public void testCheckNonExistence_multipleParamsAndNotAllowedFieldNotIncluded_ignore() throws OXException {
        this.request.setQueryString(QUERY_STRING_WITHOUT_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "password", "session"});
    }

    @Test
    public void testCheckNonExistence_configurationServiceNull_ignore() throws OXException {
        Tools.setConfigurationService(null);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "password", "session"});
    }

    @Test
    public void testCheckNonExistence_configuredToNotCheck_ignore() throws OXException {
        Mockito.when((Object)this.configurationService.getBoolProperty("com.openexchange.check.url.params", true)).thenReturn((Object)Boolean.FALSE);
        this.request.setQueryString(QUERY_STRING_WITHOUT_PASSWORD);
        Tools.checkNonExistence((HttpServletRequest)this.request, (String[])new String[]{"ignore", "mail", "password", "session"});
    }

    @Test
    public void testForBug44409() {
        ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
        String errorPage = Tools.getErrorPage((int)403, null, (String)"SES-0203 Categories=TRY_AGAIN Message='Your session <script>alert('XSS')</script>' expired. Please start a new browser session.' exceptionID=1-3");
        Assert.assertTrue((String)("Not properly encoded for HTML:\n" + errorPage), (errorPage.indexOf("<script>") < 0 ? 1 : 0) != 0);
    }
}

