/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.mail.mime.utils.MimeMessageUtility;
import junit.framework.TestCase;

public class MimeMessageUtilityTest
extends TestCase {
    public void testForBug33044_SubjectUnfolding() {
        String s = "=?UTF-8?B?UG90d2llcmR6ZW5pZSB6YW3Ds3dp?=\r\n =?UTF-8?B?ZW5pYQ==?=";
        s = MimeMessageUtility.decodeEnvelopeSubject((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Subject nor properly unfolded/decoded.", (String)"Potwierdzenie zam\u00f3wienia", (String)s);
    }

    public void testForBug36072_AddressUnfolding() {
        String s = "=?UTF-8?Q?Wielkoszcz=C4=99ko=C5=9Bciskowiczkiewi?= =?UTF-8?Q?cz=C3=B3wnaOm=C3=B3jbo=C5=BCejestemno=C5=BCemwie?= =?UTF-8?Q?leznacz=C4=85cychznak=C3=B3wsi=C4=99znaczyb?= =?UTF-8?Q?oprzecie=C5=BCniemo=C5=BCeby=C4=87zbyt=C5=82atwo!?= <foo@bar.tld>";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Address nor properly unfolded/decoded.", (String)"Wielkoszcz\u0119ko\u015bciskowiczkiewicz\u00f3wnaOm\u00f3jbo\u017cejestemno\u017cemwieleznacz\u0105cychznak\u00f3wsi\u0119znaczyboprzecie\u017cniemo\u017ceby\u0107zbyt\u0142atwo! <foo@bar.tld>", (String)s);
        s = "=?ISO-8859-1?Q?a?= b";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"a b", (String)s);
        s = "=?ISO-8859-1?Q?a?= =?ISO-8859-1?Q?b?=";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"ab", (String)s);
        s = "=?ISO-8859-1?Q?a?=  =?ISO-8859-1?Q?b?=";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"ab", (String)s);
        s = "=?ISO-8859-1?Q?a?=\r\n\t=?ISO-8859-1?Q?b?=";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"ab", (String)s);
        s = "=?ISO-8859-1?Q?a_b?=";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"a b", (String)s);
        s = "=?ISO-8859-1?Q?a?= =?ISO-8859-2?Q?_b?=";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"a b", (String)s);
        s = "a b";
        s = MimeMessageUtility.decodeMultiEncodedHeader((String)s);
        MimeMessageUtilityTest.assertEquals((String)"Not properly unfolded/decoded.", (String)"a b", (String)s);
    }
}

