/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.notify.ParticipantNotify;
import org.junit.Assert;
import org.junit.Test;

public class ParticipantNotifyTest {
    private UserParticipant userParticipant1 = new UserParticipant(1);
    private UserParticipant userParticipant2 = new UserParticipant(2);
    private UserParticipant userParticipant3 = new UserParticipant(3);
    private UserParticipant notIncludedUser = new UserParticipant(4);
    private UserParticipant[] userParticipants = new UserParticipant[]{this.userParticipant1, this.userParticipant2, this.userParticipant3};

    @Test
    public void testContains_toSearchNull_ReturnFalse() {
        boolean containsUser = ParticipantNotify.contains(null, (Participant[])this.userParticipants);
        Assert.assertFalse((boolean)containsUser);
    }

    @Test
    public void testContains_ArrayToSearchWithinNull_ReturnFalse() {
        boolean containsUser = ParticipantNotify.contains((Participant)this.userParticipant1, null);
        Assert.assertFalse((boolean)containsUser);
    }

    @Test
    public void testContains_UserNotIncludedInSearchArray_ReturnTrue() {
        boolean containsUser = ParticipantNotify.contains((Participant)this.notIncludedUser, (Participant[])this.userParticipants);
        Assert.assertFalse((boolean)containsUser);
    }

    @Test
    public void testContains_UserIncludedInSearchArray_ReturnTrue() {
        boolean containsUser = ParticipantNotify.contains((Participant)this.userParticipant3, (Participant[])this.userParticipants);
        Assert.assertTrue((boolean)containsUser);
    }
}

