/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.Tools;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class MultipleServiceTracker
implements ServiceTrackerCustomizer<Object, Object> {
    private final Lock lock = new ReentrantLock();
    private final BundleContext context;
    private final Class<?>[] neededServices;
    private final Object[] foundServices;
    private boolean invoked = false;

    public MultipleServiceTracker(BundleContext context, Class<?> ... neededServices) {
        this.context = context;
        this.neededServices = neededServices;
        this.foundServices = new Object[neededServices.length];
    }

    public ServiceTracker<Object, Object> createTracker() throws InvalidSyntaxException {
        return new ServiceTracker(this.context, this.getFilter(), (ServiceTrackerCustomizer)this);
    }

    public Filter getFilter() throws InvalidSyntaxException {
        return Tools.generateServiceFilter(this.context, this.neededServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        Object obj = this.context.getService(reference);
        boolean allAvailable = true;
        this.lock.lock();
        try {
            for (int i = 0; i < this.neededServices.length; ++i) {
                if (this.neededServices[i].isAssignableFrom(obj.getClass())) {
                    this.foundServices[i] = obj;
                }
                allAvailable &= null != this.foundServices[i];
            }
            if (allAvailable &= false == this.invoked) {
                this.onAllAvailable();
                this.invoked = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return obj;
    }

    public void modifiedService(ServiceReference<Object> arg0, Object arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        boolean someServiceMissing = false;
        this.lock.lock();
        try {
            for (int i = 0; i < this.neededServices.length; ++i) {
                if (this.neededServices[i].isAssignableFrom(service.getClass())) {
                    this.foundServices[i] = null;
                }
                someServiceMissing |= null == this.foundServices[i];
            }
            if (this.invoked && someServiceMissing && this.serviceRemoved(service)) {
                this.invoked = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.context.ungetService(reference);
    }

    protected <S> S getTrackedService(Class<? extends S> clazz) {
        for (int i = 0; i < this.neededServices.length; ++i) {
            if (!this.neededServices[i].isAssignableFrom(clazz)) continue;
            return (S)this.foundServices[i];
        }
        return null;
    }

    protected abstract void onAllAvailable();

    protected abstract boolean serviceRemoved(Object var1);
}

