/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internet;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.DateMessagingHeader;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.generic.Utility;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class MimeDateMessagingHeader
implements DateMessagingHeader {
    private final String name;
    private final long time;
    private final String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeDateMessagingHeader(String name, long time) {
        SimpleDateFormat mdf;
        this.name = name;
        this.time = time;
        SimpleDateFormat simpleDateFormat = mdf = Utility.getDefaultMailDateFormat();
        synchronized (simpleDateFormat) {
            this.value = mdf.format(new Date(time));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeDateMessagingHeader(String name, String formattedDate) throws OXException {
        SimpleDateFormat mdf;
        this.name = name;
        this.value = formattedDate;
        SimpleDateFormat simpleDateFormat = mdf = Utility.getDefaultMailDateFormat();
        synchronized (simpleDateFormat) {
            try {
                Date parsedDate = mdf.parse(formattedDate);
                this.time = parsedDate.getTime();
            }
            catch (ParseException e) {
                throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeDateMessagingHeader(String name, Date date) {
        SimpleDateFormat mdf;
        this.name = name;
        this.time = date.getTime();
        SimpleDateFormat simpleDateFormat = mdf = Utility.getDefaultMailDateFormat();
        synchronized (simpleDateFormat) {
            this.value = mdf.format(date);
        }
    }

    public MessagingHeader.HeaderType getHeaderType() {
        return MessagingHeader.HeaderType.DATE;
    }

    public long getTime() {
        return this.time;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

