/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.SimpleTokenizer;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SimpleTokenizerTest
extends SimpleTokenizer {
    @Test
    public void testBasicPhraseQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)"\"Only one token\"");
        Assert.assertEquals((String)"Wrong number of tokens", (long)1L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"Only one token", tokens.get(0));
    }

    @Test
    public void testBasicQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)"These are four tokens");
        Assert.assertEquals((String)"Wrong number of tokens", (long)4L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"These", tokens.get(0));
        Assert.assertEquals((String)"Wrong token", (Object)"are", tokens.get(1));
        Assert.assertEquals((String)"Wrong token", (Object)"four", tokens.get(2));
        Assert.assertEquals((String)"Wrong token", (Object)"tokens", tokens.get(3));
    }

    @Test
    public void testComplexQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)" Expect \"two strings\" as \"not tokenized\" and\nfive\rothers ");
        Assert.assertEquals((String)"Wrong number of tokens", (long)7L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"Expect", tokens.get(0));
        Assert.assertEquals((String)"Wrong token", (Object)"two strings", tokens.get(1));
        Assert.assertEquals((String)"Wrong token", (Object)"as", tokens.get(2));
        Assert.assertEquals((String)"Wrong token", (Object)"not tokenized", tokens.get(3));
        Assert.assertEquals((String)"Wrong token", (Object)"and", tokens.get(4));
        Assert.assertEquals((String)"Wrong token", (Object)"five", tokens.get(5));
        Assert.assertEquals((String)"Wrong token", (Object)"others", tokens.get(6));
    }

    @Test
    public void testBrokenQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)"Something \" went wrong here");
        Assert.assertEquals((String)"Wrong number of tokens", (long)4L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"Something", tokens.get(0));
        Assert.assertEquals((String)"Wrong token", (Object)"went", tokens.get(1));
        Assert.assertEquals((String)"Wrong token", (Object)"wrong", tokens.get(2));
        Assert.assertEquals((String)"Wrong token", (Object)"here", tokens.get(3));
    }

    @Test
    public void testBrokenQuery2() {
        List tokens = SimpleTokenizerTest.tokenize((String)"Something \"went wrong\" here \"");
        Assert.assertEquals((String)"Wrong number of tokens", (long)3L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"Something", tokens.get(0));
        Assert.assertEquals((String)"Wrong token", (Object)"went wrong", tokens.get(1));
        Assert.assertEquals((String)"Wrong token", (Object)"here", tokens.get(2));
    }

    @Test
    public void testBrokenQuery3() {
        List tokens = SimpleTokenizerTest.tokenize((String)"\" Something went wrong here ");
        Assert.assertEquals((String)"Wrong number of tokens", (long)4L, (long)tokens.size());
        Assert.assertEquals((String)"Wrong token", (Object)"Something", tokens.get(0));
        Assert.assertEquals((String)"Wrong token", (Object)"went", tokens.get(1));
        Assert.assertEquals((String)"Wrong token", (Object)"wrong", tokens.get(2));
        Assert.assertEquals((String)"Wrong token", (Object)"here", tokens.get(3));
    }

    @Test
    public void testEmptyQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)"");
        Assert.assertEquals((String)"Wrong number of tokens", (long)0L, (long)tokens.size());
    }

    @Test
    public void testWhitespaceQuery() {
        List tokens = SimpleTokenizerTest.tokenize((String)"  \" \" ");
        Assert.assertEquals((String)"Wrong number of tokens", (long)0L, (long)tokens.size());
    }
}

