/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception.internal;

import com.openexchange.i18n.I18nService;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class I18n {
    private static final I18n SINGLETON = new I18n();
    private final ConcurrentMap<Locale, I18nService> services = new ConcurrentHashMap<Locale, I18nService>(4, 0.9f, 1);

    private I18n() {
    }

    public static final I18n getInstance() {
        return SINGLETON;
    }

    public boolean addI18nService(I18nService service) {
        return null == this.services.putIfAbsent(service.getLocale(), service);
    }

    public void removeI18nService(I18nService service) {
        this.services.remove(service.getLocale());
    }

    public I18nService get(Locale locale) {
        return (I18nService)this.services.get(locale);
    }

    public String translate(Locale locale, String translateMe) {
        if (null == translateMe) {
            return null;
        }
        I18nService service = (I18nService)this.services.get(locale);
        if (null != service) {
            return service.getLocalized(translateMe);
        }
        return translateMe;
    }
}

