/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.fileholder;

import com.openexchange.ajax.fileholder.IFileHolder;
import java.io.IOException;

public class ByteArrayRandomAccess
implements IFileHolder.RandomAccess {
    private final byte[] bytes;
    private int pos;

    public ByteArrayRandomAccess(byte[] bytes) {
        this.bytes = bytes;
        this.pos = 0;
    }

    @Override
    public long length() throws IOException {
        return this.bytes.length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        int count = this.bytes.length;
        if (this.pos >= count) {
            return -1;
        }
        int length = len;
        int avail = count - this.pos;
        if (length > avail) {
            length = avail;
        }
        if (length <= 0) {
            return 0;
        }
        System.arraycopy(this.bytes, this.pos, b, off, length);
        this.pos += length;
        return length;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.pos = (int)pos;
    }

    @Override
    public void close() throws IOException {
    }
}

