/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.FileActionTest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.actions.files.UpdatesAction;
import com.openexchange.groupware.results.Results;
import com.openexchange.time.TimeTools;
import java.util.Arrays;
import java.util.List;

public class UpdatesTest
extends FileActionTest {
    public void testMissingParameters() {
        try {
            this.action.handle((InfostoreRequest)this.request());
            UpdatesTest.fail((String)"Expected Exception due to missing parameters");
        }
        catch (OXException x) {
            UpdatesTest.assertTrue((boolean)true);
        }
    }

    public void testAction() throws OXException {
        this.request().param("folder", "12").param("columns", "1,700,702").param("timestamp", "" + TimeTools.D((String)"Yesterday at 12:00").getTime()).param("sort", "700").param("order", "desc").param("ignore", "deleted").param("timezone", "Europe/Berlin");
        List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.TITLE, File.Field.FILENAME);
        this.fileAccess().expectCall("getDelta", new Object[]{"12", TimeTools.D((String)"Yesterday at 12:00").getTime(), columns, File.Field.TITLE, FileStorageFileAccess.SortDirection.DESC, true}).andReturn((Object)Results.emptyDelta());
        this.perform();
        this.fileAccess().assertAllWereCalled();
    }

    public void testTimestampDefaultsToDistantPast() throws OXException {
        this.request().param("folder", "12").param("columns", "1,700,702").param("sort", "700").param("order", "desc").param("ignore", "deleted").param("timezone", "Europe/Berlin");
        List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.TITLE, File.Field.FILENAME);
        this.fileAccess().expectCall("getDelta", new Object[]{"12", Long.MIN_VALUE, columns, File.Field.TITLE, FileStorageFileAccess.SortDirection.DESC, true}).andReturn((Object)Results.emptyDelta());
        this.perform();
        this.fileAccess().assertAllWereCalled();
    }

    @Override
    public AbstractFileAction createAction() {
        return new UpdatesAction();
    }
}

