/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.FileMetadataWriter;
import com.openexchange.file.storage.json.FileTest;
import com.openexchange.file.storage.json.JsonFieldHandler;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.TestFriendlyInfostoreRequest;
import com.openexchange.json.JSONAssertion;
import com.openexchange.time.TimeTools;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileWriterTest
extends FileTest {
    FileMetadataWriter writer = new FileMetadataWriter(null);

    public void testWriteFileAsArray() throws JSONException {
        DefaultFile f = this.createFile();
        JSONArray array = this.writer.writeArray(new JsonFieldHandler((AJAXInfostoreRequest)new TestFriendlyInfostoreRequest()), (File)f, Arrays.asList(File.Field.CATEGORIES, File.Field.COLOR_LABEL, File.Field.CREATED, File.Field.CREATED_BY, File.Field.DESCRIPTION, File.Field.FILE_MD5SUM, File.Field.FILE_MIMETYPE, File.Field.FILENAME, File.Field.FILE_SIZE, File.Field.FOLDER_ID, File.Field.ID, File.Field.CURRENT_VERSION, File.Field.LAST_MODIFIED, File.Field.LAST_MODIFIED_UTC, File.Field.LOCKED_UNTIL, File.Field.MODIFIED_BY, File.Field.NUMBER_OF_VERSIONS, File.Field.TITLE, File.Field.URL, File.Field.VERSION, File.Field.VERSION_COMMENT));
        FileWriterTest.assertNotNull((Object)array);
        JSONAssertion.assertValidates((JSONAssertion)new JSONAssertion().isArray().withValues(new Object[]{"cat1", "cat2", "cat3"}).inStrictOrder(), (Object)array.getJSONArray(0));
        FileWriterTest.assertEquals((int)12, (int)array.getInt(1));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 08:00").getTime(), (long)array.getLong(2));
        FileWriterTest.assertEquals((int)3, (int)array.getInt(3));
        FileWriterTest.assertEquals((String)"description", (String)array.getString(4));
        FileWriterTest.assertEquals((String)"md5sum", (String)array.getString(5));
        FileWriterTest.assertEquals((String)"mime/type", (String)array.getString(6));
        FileWriterTest.assertEquals((String)"name.txt", (String)array.getString(7));
        FileWriterTest.assertEquals((long)1337L, (long)array.getLong(8));
        FileWriterTest.assertEquals((String)"folder 3", (String)array.getString(9));
        FileWriterTest.assertEquals((String)"Id 23", (String)array.getString(10));
        FileWriterTest.assertEquals((boolean)true, (boolean)array.getBoolean(11));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 10:00").getTime(), (long)array.getLong(12));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 10:00").getTime(), (long)array.getLong(13));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 18:00").getTime(), (long)array.getLong(14));
        FileWriterTest.assertEquals((int)22, (int)array.getInt(15));
        FileWriterTest.assertEquals((int)2, (int)array.getInt(16));
        FileWriterTest.assertEquals((String)"Nice Title", (String)array.getString(17));
        FileWriterTest.assertEquals((String)"url", (String)array.getString(18));
        FileWriterTest.assertEquals((int)2, (int)array.getInt(19));
        FileWriterTest.assertEquals((String)"version comment", (String)array.getString(20));
    }

    private DefaultFile createFile() {
        DefaultFile f = new DefaultFile();
        f.setCategories("cat1, cat2, cat3");
        f.setColorLabel(12);
        f.setCreated(TimeTools.D((String)"Today at 08:00"));
        f.setCreatedBy(3);
        f.setDescription("description");
        f.setFileMD5Sum("md5sum");
        f.setFileMIMEType("mime/type");
        f.setFileName("name.txt");
        f.setFileSize(1337L);
        f.setFolderId("folder 3");
        f.setId("Id 23");
        f.setIsCurrentVersion(true);
        f.setLastModified(TimeTools.D((String)"Today at 10:00"));
        f.setLockedUntil(TimeTools.D((String)"Today at 18:00"));
        f.setModifiedBy(22);
        f.setNumberOfVersions(2);
        f.setTitle("Nice Title");
        f.setURL("url");
        f.setVersion("2");
        f.setVersionComment("version comment");
        return f;
    }

    public void testTimezone() throws JSONException {
        DefaultFile f = new DefaultFile();
        f.setCreated(TimeTools.D((String)"Today at 10:00"));
        f.setLastModified(TimeTools.D((String)"Today at 12:00"));
        f.setLockedUntil(TimeTools.D((String)"Today at 20:00"));
        JSONArray array = this.writer.writeArray(new JsonFieldHandler((AJAXInfostoreRequest)new TestFriendlyInfostoreRequest("GMT-2")), (File)f, Arrays.asList(File.Field.CREATED, File.Field.LAST_MODIFIED, File.Field.LAST_MODIFIED_UTC, File.Field.LOCKED_UNTIL));
        FileWriterTest.assertNotNull((Object)array);
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 08:00").getTime(), (long)array.getLong(0));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 10:00").getTime(), (long)array.getLong(1));
        FileWriterTest.assertEquals((long)TimeTools.D((String)"Today at 12:00").getTime(), (long)array.getLong(2));
    }

    public void testWriteAsObject() {
        DefaultFile file = this.createFile();
        JSONObject object = this.writer.write((AJAXInfostoreRequest)new TestFriendlyInfostoreRequest(), (File)file);
    }
}

