/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.osgi.OSGIFileStorageServiceRegistry;
import com.openexchange.quota.AccountQuota;
import com.openexchange.quota.DefaultAccountQuota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.quota.QuotaType;
import com.openexchange.session.Session;
import com.openexchange.tools.id.IDMangler;
import java.util.LinkedList;
import java.util.List;

public class FileStorageQuotaProvider
implements QuotaProvider {
    private final OSGIFileStorageServiceRegistry storageRegistry;

    public FileStorageQuotaProvider(OSGIFileStorageServiceRegistry storageRegistry) {
        this.storageRegistry = storageRegistry;
    }

    public String getModuleID() {
        return "filestorage";
    }

    public String getDisplayName() {
        return "Drive";
    }

    public AccountQuota getFor(Session session, String accountID) throws OXException {
        List unmangled = IDMangler.unmangle((String)accountID);
        String serviceID = null;
        if (unmangled.size() == 2) {
            serviceID = (String)unmangled.get(0);
            accountID = (String)unmangled.get(1);
        }
        if (serviceID == null) {
            List<FileStorageService> storageServices = this.storageRegistry.getAllServices();
            for (FileStorageService storageService : storageServices) {
                AccountQuota accountQuota = this.getForService(session, accountID, storageService);
                if (accountQuota == null) continue;
                return accountQuota;
            }
        } else {
            AccountQuota accountQuota = this.getForService(session, accountID, this.storageRegistry.getFileStorageService(serviceID));
            if (accountQuota != null) {
                return accountQuota;
            }
        }
        throw QuotaExceptionCodes.UNKNOWN_ACCOUNT.create(new Object[]{accountID, this.getModuleID()});
    }

    public List<AccountQuota> getFor(Session session) throws OXException {
        LinkedList<AccountQuota> accountQuotas = new LinkedList<AccountQuota>();
        for (FileStorageService storageService : this.storageRegistry.getAllServices()) {
            FileStorageAccountManager accountManager = storageService.getAccountManager();
            List<FileStorageAccount> accounts = accountManager.getAccounts(session);
            for (FileStorageAccount account : accounts) {
                accountQuotas.add(FileStorageQuotaProvider.getAccountQuota(account, session));
            }
        }
        return accountQuotas;
    }

    private AccountQuota getForService(Session session, String accountID, FileStorageService storageService) throws OXException {
        FileStorageAccountManager accountManager = storageService.getAccountManager();
        for (FileStorageAccount account : accountManager.getAccounts(session)) {
            if (!account.getId().equals(accountID)) continue;
            return FileStorageQuotaProvider.getAccountQuota(account, session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccountQuota getAccountQuota(FileStorageAccount account, Session session) throws OXException {
        String accountID = account.getId();
        accountAccess.connect();
        try (FileStorageAccountAccess accountAccess = account.getFileStorageService().getAccountAccess(accountID, session);){
            FileStorageFolderAccess folderAccess = accountAccess.getFolderAccess();
            FileStorageFolder rootFolder = folderAccess.getRootFolder();
            Quota[] quotas = folderAccess.getQuotas(rootFolder.getId(), new Quota.Type[]{Quota.Type.FILE, Quota.Type.STORAGE});
            DefaultAccountQuota accountQuota = new DefaultAccountQuota(accountID, account.getDisplayName());
            if (quotas != null) {
                block7: for (Quota quota : quotas) {
                    long limit = quota.getLimit();
                    switch (quota.getType()) {
                        case FILE: {
                            if (limit == -1L) {
                                accountQuota.addQuota(com.openexchange.quota.Quota.UNLIMITED_AMOUNT);
                                continue block7;
                            }
                            accountQuota.addQuota(QuotaType.AMOUNT, limit, quota.getUsage());
                            continue block7;
                        }
                        case STORAGE: {
                            if (limit == -1L) {
                                accountQuota.addQuota(com.openexchange.quota.Quota.UNLIMITED_SIZE);
                                continue block7;
                            }
                            accountQuota.addQuota(QuotaType.SIZE, limit, quota.getUsage());
                        }
                    }
                }
            }
            DefaultAccountQuota defaultAccountQuota = accountQuota;
            return defaultAccountQuota;
        }
    }
}

