/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum DriveExceptionCodes implements DisplayableOXExceptionCode
{
    INVALID_PATH("The path \"%1$s\" is invalid.", "The path \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 1),
    PATH_NOT_FOUND("The path \"%1$s\" was not found. Please retry the synchronization.", "The path \"%1$s\" was not found. Please retry the synchronization.", Category.CATEGORY_USER_INPUT, 2),
    FILE_NOT_FOUND("The file \"%1$s\" was not found at \"%2$s\". Please retry the synchronization.", "The file \"%1$s\" was not found at \"%2$s\". Please retry the synchronization.", Category.CATEGORY_USER_INPUT, 3),
    IO_ERROR("An I/O error occurred: \"%1$s\"", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_CONNECTIVITY, 4),
    INVALID_FILE_OFFSET("The file offset \"%1$d\" is invalid", "Unable to access the file at the requested position. Please retry the synchronization.", Category.CATEGORY_USER_INPUT, 5),
    DB_ERROR("Unexpected database error: \"%1$s\"", "Error while reading/writing data from/to the database.", Category.CATEGORY_WARNING, 6),
    FILEVERSION_NOT_FOUND("The file \"%1$s\" with checksum \"%2$s\" was not found at \"%3$s\"", "The file version \"%1$s\" was not found at \"%3$s\". Please retry the synchronization.", Category.CATEGORY_USER_INPUT, 7),
    NO_CHECKSUM_FOR_FILE("No checksum for file \"%1$s\" available", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_WARNING, 8),
    UPLOADED_FILE_CHECKSUM_ERROR("Checksum \"%1$s\" for uploaded file \"%2$s\" different from \"%3$s\"", "Integrity checks failed for uploaded file \"%2$s\". Please try again.", Category.CATEGORY_USER_INPUT, 9),
    DIRECTORYVERSION_NOT_FOUND("The directory \"%1$s\" with checksum \"%2$s\" was not found", "The directory version \"%1$s\" was not found. Please retry the synchronization.", Category.CATEGORY_USER_INPUT, 10),
    NO_DELETE_FILE_PERMISSION("You are not allowed to delete the file \"%1$s\" at \"%2$s\".", "You are not allowed to delete the file \"%1$s\" at \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 11),
    NO_CREATE_FILE_PERMISSION("You are not allowed to create files at \"%1$s\".", "You are not allowed to create files at \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 12),
    NO_MODIFY_FILE_PERMISSION("You are not allowed to modify the file \"%1$s\" at \"%2$s\".", "You are not allowed to modify the file \"%1$s\" at \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 13),
    NO_DELETE_DIRECTORY_PERMISSION("You are not allowed to delete the directory \"%1$s\".", "You are not allowed to delete the directory \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 14),
    NO_CREATE_DIRECTORY_PERMISSION("You are not allowed to create directories at \"%1$s\".", "You are not allowed to create directories at \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 15),
    QUOTA_REACHED("The allowed quota is reached.", "The allowed quota is reached.", Category.CATEGORY_CAPACITY, 16),
    INVALID_FILENAME("The file name \"%1$s\" is invalid.", "The file name \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 17),
    IGNORED_FILENAME("The file name \"%1$s\" is ignored.", "The file name \"%1$s\" is ignored.", Category.CATEGORY_USER_INPUT, 18),
    CONFLICTING_PATH("The path \"%1$s\" is conflicting.", "The path \"%1$s\" is conflicting.", Category.CATEGORY_CONFLICT, 19),
    INVALID_FILEVERSION("The file version \"%1$s\" with checksum \"%2$s\" is invalid", "The file version \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 20),
    INVALID_DIRECTORYVERSION("The directory version \"%1$s\" with checksum \"%2$s\" is invalid", "The directory version \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 21),
    LONG_POLLING_NOT_AVAILABLE("Push via long polling is not available", "Push updates are not available.", Category.CATEGORY_SERVICE_DOWN, 22),
    SERVER_BUSY("The server is too busy at the moment - please try again later.", "The server is too busy at the moment - please try again later.", Category.CATEGORY_TRY_AGAIN, 23),
    IGNORED_PATH("The path \"%1$s\" is ignored.", "The path \"%1$s\" is ignored.", Category.CATEGORY_USER_INPUT, 24),
    CONFLICTING_FILENAME("The file name \"%1$s\" is conflicting.", "The file name \"%1$s\" is conflicting.", Category.CATEGORY_CONFLICT, 25),
    REPEATED_SYNC_PROBLEMS("The directory \"%1$s\" with checksum \"%2$s\" caused repeated synchronization problems", "The directory \"%1$s\" caused repeated synchronization problems.", Category.CATEGORY_WARNING, 26),
    CLIENT_OUTDATED("The client application you're using is outdated and no longer supported - please upgrade to a newer version.", "The client application you're using is outdated and no longer supported - please upgrade to a newer version.", Category.CATEGORY_WARNING, 27),
    CLIENT_VERSION_OUTDATED("Client outdated - current: \"%1$s\", required: \"%2$s\"", "The client application you're using is outdated and no longer supported - please upgrade to a newer version.", Category.CATEGORY_WARNING, 28),
    CLIENT_VERSION_UPDATE_AVAILABLE("Client update available - current: \"%1$s\", available: \"%2$s\"", "A newer version of your client application is available for download.", Category.CATEGORY_WARNING, 29),
    INVALID_PATTERN("The pattern \"%1$s\" is invalid: \"%2$s\"", "The pattern \"%1$s\" is invalid. Please use a valid pattern and try again.", Category.CATEGORY_USER_INPUT, 30),
    LEVEL_CONFLICTING_FILENAME("The file name \"%1$s\" is conflicting with an equally named directory at \"%2$s\".", "The file name \"%1$s\" is conflicting with an equally named directory at \"%2$s\".", Category.CATEGORY_CONFLICT, 31),
    LEVEL_CONFLICTING_PATH("The path \"%1$s\" is conflicting with an equally named file at \"%2$s\".", "The path \"%1$s\" is conflicting with an equally named file at \"%2$s\".", Category.CATEGORY_CONFLICT, 32),
    NOT_SYNCHRONIZABLE_DIRECTORY("The directory \"%1$s\" is not synchronizable. Please select another directory.", "The directory \"%1$s\" is not synchronizable. Please select another directory.", Category.CATEGORY_USER_INPUT, 33),
    METDATA_PARSE_ERROR("The supplied metadata could not be parsed: \"%1$s\"", "The supplied metadata could not be parsed: \"%1$s\"", Category.CATEGORY_USER_INPUT, 34),
    TOO_MANY_DIRECTORIES("The maximum number of synchronizable directories (%1$d) is exceeded. Please remove some directories and try again, or select another root folder.", "The maximum number of synchronizable directories (%1$d) is exceeded. Please remove some directories and try again, or select another root folder.", Category.CATEGORY_CAPACITY, 35),
    TOO_MANY_FILES("The maximum number of files (%1$d) is exceeded in directory \"%2$s\". Please remove some files and try again.", "The maximum number of files (%1$d) is exceeded in directory \"%2$s\". Please remove some files and try again.", Category.CATEGORY_CAPACITY, 36),
    TOKEN_ALREADY_REGISTERED("The token \"%1$s\" is already registered.", "The token \"%1$s\" is already registered.", Category.CATEGORY_CONFLICT, 37),
    CLIENT_CONNECTION_LOST("Client connection lost unexpectedly", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CONNECTIVITY, 38),
    ZERO_BYTE_FILES("Empty files indicated for directory \"%1$s\".", "Empty files indicated for directory \"%1$s\".", Category.CATEGORY_ERROR, 39);

    private static final String PREFIX = "DRV";
    private final Category category;
    private final int number;
    private final String message;
    private final String displayMessage;

    private DriveExceptionCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.number = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return null != this.displayMessage ? this.displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

