/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal;

import com.openexchange.annotation.NonNull;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Filter;
import com.openexchange.config.ForcedReloadable;
import com.openexchange.config.PropertyFilter;
import com.openexchange.config.PropertyListener;
import com.openexchange.config.Reloadable;
import com.openexchange.config.WildcardFilter;
import com.openexchange.config.cascade.ReinitializableConfigProviderService;
import com.openexchange.config.internal.ConfigProviderServiceImpl;
import com.openexchange.config.internal.FileProcessor;
import com.openexchange.config.internal.PropertyWatcher;
import com.openexchange.config.internal.filewatcher.FileWatcher;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ho.yaml.Yaml;
import org.ho.yaml.exception.YamlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationImpl
implements ConfigurationService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    private static final FileNameMatcher PATH_MATCHER = new FileNameMatcher(){

        @Override
        public boolean matches(String filename, File file) {
            return file.getPath().endsWith(filename);
        }
    };
    private static final FileNameMatcher NAME_MATCHER = new FileNameMatcher(){

        @Override
        public boolean matches(String filename, File file) {
            return file.getName().equals(filename);
        }
    };
    private final ConcurrentMap<String, Reloadable> reloadableServices;
    private final Map<String, String> texts;
    private final File[] dirs;
    private final Map<File, Properties> propertiesByFile;
    private final Map<String, String> properties;
    private final Map<String, String> propertiesFiles;
    private final Map<File, byte[]> yamlFiles;
    private final Map<String, File> yamlPaths;
    private final Map<File, byte[]> xmlFiles;
    private volatile ConfigProviderServiceImpl configProviderServiceImpl;
    private final Collection<ReinitializableConfigProviderService> reinitQueue;

    private static final String[] getDirectories() {
        boolean checkNext;
        ArrayList<String> properties = new ArrayList<String>(4);
        properties.add(System.getProperty("openexchange.propdir"));
        int i = 2;
        do {
            String sysProp;
            checkNext = false;
            if (null == (sysProp = System.getProperty("openexchange.propdir" + i++))) continue;
            properties.add(sysProp);
            checkNext = true;
        } while (checkNext);
        return properties.toArray(new String[properties.size()]);
    }

    public ConfigurationImpl(Collection<ReinitializableConfigProviderService> reinitQueue) {
        this(ConfigurationImpl.getDirectories(), reinitQueue);
    }

    public ConfigurationImpl(String[] directories, Collection<ReinitializableConfigProviderService> reinitQueue) {
        this.reinitQueue = null == reinitQueue ? Collections.emptyList() : reinitQueue;
        this.reloadableServices = new ConcurrentHashMap<String, Reloadable>(128, 0.9f, 1);
        this.propertiesByFile = new HashMap<File, Properties>(256);
        this.texts = new ConcurrentHashMap<String, String>(1024, 0.9f, 1);
        this.properties = new HashMap<String, String>(2048);
        this.propertiesFiles = new HashMap<String, String>(2048);
        this.yamlFiles = new HashMap<File, byte[]>(64);
        this.yamlPaths = new HashMap<String, File>(64);
        this.dirs = new File[directories.length];
        this.xmlFiles = new HashMap<File, byte[]>(2048);
        this.loadConfiguration(directories);
    }

    private void loadConfiguration(String[] directories) {
        if (null == directories || directories.length == 0) {
            throw new IllegalArgumentException("Missing configuration directory path.");
        }
        PropertyFileFilter fileFilter = new PropertyFileFilter();
        FileProcessor processor = new FileProcessor(){

            @Override
            public void processFile(File file) {
                ConfigurationImpl.this.processPropertiesFile(file);
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".yml") || pathname.getName().endsWith(".yaml");
            }
        };
        final Map<String, File> yamlPaths = this.yamlPaths;
        final Map<File, byte[]> yamlFiles = this.yamlFiles;
        FileProcessor processor2 = new FileProcessor(){

            @Override
            public void processFile(File file) {
                yamlPaths.put(file.getName(), file);
                yamlFiles.put(file, ConfigurationImpl.this.readFile(file).getBytes());
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        };
        final Map<File, byte[]> xmlFiles = this.xmlFiles;
        FileProcessor processor3 = new FileProcessor(){

            @Override
            public void processFile(File file) {
                byte[] hash = ConfigurationImpl.this.getHash(file);
                xmlFiles.put(file, hash);
            }
        };
        for (int i = 0; i < directories.length; ++i) {
            File dir;
            if (null == directories[i]) {
                throw new IllegalArgumentException("Given configuration directory path is null.");
            }
            this.dirs[i] = dir = new File(directories[i]);
            if (!dir.exists()) {
                throw new IllegalArgumentException(MessageFormat.format("Not found: \"{0}\".", directories[i]));
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(MessageFormat.format("Not a directory: {0}", directories[i]));
            }
            this.processDirectory(dir, fileFilter, processor);
            this.processDirectory(dir, fileFilter2, processor2);
            this.processDirectory(dir, fileFilter3, processor3);
        }
    }

    private synchronized void processDirectory(File dir, FileFilter fileFilter, FileProcessor processor) {
        File[] files = dir.listFiles(fileFilter);
        if (files == null) {
            LOG.info("Cannot read {}. Skipping.", (Object)dir);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.processDirectory(file, fileFilter, processor);
                continue;
            }
            processor.processFile(file);
        }
    }

    void processPropertiesFile(File propFile) {
        try {
            if (!propFile.exists() || !propFile.canRead()) {
                return;
            }
            Properties tmp = ConfigurationImpl.loadProperties(propFile);
            this.propertiesByFile.put(propFile, tmp);
            String propFilePath = propFile.getPath();
            boolean debug = LOG.isDebugEnabled();
            for (Map.Entry<Object, Object> e : tmp.entrySet()) {
                String otherValue;
                String propName = e.getKey().toString().trim();
                if (debug && (otherValue = this.properties.get(propName)) != null && !otherValue.equals(e.getValue())) {
                    String otherFile = this.propertiesFiles.get(propName);
                    LOG.debug("Overwriting property {} from file ''{}'' with property from file ''{}'', overwriting value ''{}'' with value ''{}''", new Object[]{propName, otherFile, propFilePath, otherValue, e.getValue()});
                }
                this.properties.put(propName, e.getValue().toString().trim());
                this.propertiesFiles.put(propName, propFilePath);
            }
        }
        catch (IOException e) {
            LOG.warn("An I/O error occurred while processing .properties file \"{}\".", (Object)propFile, (Object)e);
        }
        catch (IllegalArgumentException encodingError) {
            LOG.warn("A malformed Unicode escape sequence in .properties file \"{}\".", (Object)propFile, (Object)encodingError);
        }
        catch (RuntimeException e) {
            LOG.warn("An error occurred while processing .properties file \"{}\".", (Object)propFile, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File propFile) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propFile), 65536);
        try {
            Properties tmp = new Properties();
            tmp.load(fis);
            Properties properties = tmp;
            return properties;
        }
        finally {
            Streams.close((Closeable)fis);
        }
    }

    @Override
    public Filter getFilterFromProperty(String name) {
        String value = this.properties.get(name);
        if (null == value) {
            return null;
        }
        return new WildcardFilter(value);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        return null == value ? defaultValue : value;
    }

    @Override
    public String getProperty(String name, PropertyListener listener) {
        if (this.watchProperty(name, listener)) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public String getProperty(String name, String defaultValue, PropertyListener listener) {
        if (this.watchProperty(name, listener)) {
            return this.properties.get(name);
        }
        return defaultValue;
    }

    @Override
    public List<String> getProperty(String name, String defaultValue, String separator) {
        String property = this.getProperty(name, defaultValue);
        return Strings.splitAndTrim((String)property, (String)separator);
    }

    @Override
    public List<String> getProperty(String name, String defaultValue, PropertyListener propertyListener, String separator) {
        if (this.watchProperty(name, propertyListener)) {
            return this.getProperty(name, defaultValue, separator);
        }
        return Strings.splitAndTrim((String)defaultValue, (String)separator);
    }

    @Override
    public void removePropertyListener(String name, PropertyListener listener) {
        PropertyWatcher pw = PropertyWatcher.getPropertyWatcher(name);
        if (pw != null) {
            pw.removePropertyListener(listener);
            if (pw.isEmpty()) {
                PropertyWatcher removedWatcher = PropertyWatcher.removePropertWatcher(name);
                FileWatcher fileWatcher = FileWatcher.optFileWatcher(new File(this.propertiesFiles.get(name)));
                if (null != fileWatcher) {
                    fileWatcher.removeFileListener(removedWatcher);
                }
            }
        }
    }

    @Override
    public Properties getFile(String fileName) {
        return this.getFile(fileName, null);
    }

    public Properties getFile(String filename, PropertyListener listener) {
        if (null == filename) {
            return new Properties();
        }
        boolean isPath = filename.indexOf(File.separatorChar) >= 0;
        FileNameMatcher matcher = isPath ? PATH_MATCHER : NAME_MATCHER;
        for (Map.Entry<File, Properties> entry : this.propertiesByFile.entrySet()) {
            if (!matcher.matches(filename, entry.getKey())) continue;
            Properties retval = new Properties();
            retval.putAll((Map<?, ?>)entry.getValue());
            if (listener != null) {
                for (Object k : retval.keySet()) {
                    this.getProperty((String)k, listener);
                }
            }
            return retval;
        }
        return new Properties();
    }

    @Override
    public Map<String, String> getProperties(PropertyFilter filter) throws OXException {
        if (null == filter) {
            return new HashMap<String, String>(this.properties);
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(32);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String value;
            String key = entry.getKey();
            if (!filter.accept(key, value = entry.getValue())) continue;
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public Properties getPropertiesInFolder(String folderName) {
        return this.getPropertiesInFolder(folderName, null);
    }

    public Properties getPropertiesInFolder(String folderName, PropertyListener listener) {
        Properties retval = new Properties();
        Iterator<Map.Entry<String, String>> iter = this.propertiesFiles.entrySet().iterator();
        String fldName = folderName;
        for (File dir : this.dirs) {
            fldName = dir.getAbsolutePath() + File.separatorChar + fldName + File.separatorChar;
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (!entry.getValue().startsWith(fldName)) continue;
                String value = null == listener ? this.getProperty(entry.getKey()) : this.getProperty(entry.getKey(), listener);
                retval.put(entry.getKey(), value);
            }
        }
        return retval;
    }

    private boolean watchProperty(String name, PropertyListener propertyListener) {
        String value = this.properties.get(name);
        if (null == value) {
            LOG.error("Unable to watch missing property: {}", (Object)name);
            return false;
        }
        PropertyWatcher pw = PropertyWatcher.addPropertyWatcher(name, value, true);
        pw.addPropertyListener(propertyListener);
        FileWatcher fileWatcher = FileWatcher.getFileWatcher(new File(this.propertiesFiles.get(name)));
        fileWatcher.addFileListener(pw);
        fileWatcher.startFileWatcher(10000L);
        return true;
    }

    @Override
    public boolean getBoolProperty(String name, boolean defaultValue) {
        String prop = this.properties.get(name);
        if (null != prop) {
            return Boolean.parseBoolean(prop.trim());
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolProperty(String name, boolean defaultValue, PropertyListener propertyListener) {
        if (this.watchProperty(name, propertyListener)) {
            return this.getBoolProperty(name, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        String prop = this.properties.get(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop.trim());
            }
            catch (NumberFormatException e) {
                LOG.trace("", (Throwable)e);
            }
        }
        return defaultValue;
    }

    @Override
    public int getIntProperty(String name, int defaultValue, PropertyListener propertyListener) {
        if (this.watchProperty(name, propertyListener)) {
            return this.getIntProperty(name, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public Iterator<String> propertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public File getFileByName(String fileName) {
        if (null == fileName) {
            return null;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            File f = this.traverseForFile(new File(dir), fileName);
            if (f == null) continue;
            return f;
        }
        int pos = fileName.lastIndexOf(47);
        if (pos < 0 && (pos = fileName.lastIndexOf(92)) < 0) {
            LOG.warn("No such file: {}", (Object)fileName);
            return null;
        }
        String fn = fileName.substring(pos + 1);
        for (String dir : ConfigurationImpl.getDirectories()) {
            File f = this.traverseForFile(new File(dir), fn);
            if (f == null) continue;
            return f;
        }
        LOG.warn("No such file: {}", (Object)fileName);
        return null;
    }

    private File traverseForFile(File file, String fileName) {
        if (null == file) {
            return null;
        }
        if (file.isFile()) {
            if (fileName.equals(file.getName())) {
                return file;
            }
            return null;
        }
        File[] subs = file.listFiles();
        if (subs != null) {
            for (File sub : subs) {
                File f = this.traverseForFile(sub, fileName);
                if (f == null) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public File getDirectory(String directoryName) {
        if (null == directoryName) {
            return null;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            File fdir = this.traverseForDir(new File(dir), directoryName);
            if (fdir == null) continue;
            return fdir;
        }
        LOG.warn("No such directory: {}", (Object)directoryName);
        return null;
    }

    private File traverseForDir(File file, String directoryName) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory() && directoryName.equals(file.getName())) {
            return file;
        }
        File[] subDirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (subDirs != null) {
            for (File subDir : subDirs) {
                if (!subDir.isDirectory() || !directoryName.equals(subDir.getName())) continue;
                return subDir;
            }
            for (File subDir : subDirs) {
                File dir = this.traverseForDir(subDir, directoryName);
                if (dir == null) continue;
                return dir;
            }
        }
        return null;
    }

    @Override
    public String getText(String fileName) {
        String text = this.texts.get(fileName);
        if (text != null) {
            return text;
        }
        for (String dir : ConfigurationImpl.getDirectories()) {
            String s = this.traverse(new File(dir), fileName);
            if (s == null) continue;
            this.texts.put(fileName, s);
            return s;
        }
        return null;
    }

    private String traverse(File file, String filename) {
        if (null == file) {
            return null;
        }
        if (file.isFile()) {
            if (file.getName().equals(filename)) {
                return this.readFile(file);
            }
            return null;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                String s = this.traverse(f, filename);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readFile(File file) {
        String string;
        InputStreamReader reader = null;
        try {
            int read;
            reader = new InputStreamReader(new FileInputStream(file));
            StringBuilder builder = new StringBuilder((int)file.length());
            int buflen = 8192;
            char[] cbuf = new char[8192];
            while ((read = ((Reader)reader).read(cbuf, 0, 8192)) > 0) {
                builder.append(cbuf, 0, read);
            }
            string = builder.toString();
        }
        catch (IOException x) {
            String string2;
            try {
                LOG.error("Can't read file: {}", (Object)file);
                string2 = null;
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
            Streams.close((Closeable)reader);
            return string2;
        }
        Streams.close((Closeable)reader);
        return string;
    }

    @Override
    public Object getYaml(String filename) {
        boolean isPath;
        if (null == filename) {
            return null;
        }
        boolean bl = isPath = filename.indexOf(File.separatorChar) >= 0;
        if (isPath) {
            FileNameMatcher matcher = PATH_MATCHER;
            for (Map.Entry<File, byte[]> entry : this.yamlFiles.entrySet()) {
                if (!matcher.matches(filename, entry.getKey())) continue;
                try {
                    return Yaml.load((String)Charsets.toString((byte[])entry.getValue(), (Charset)Charsets.UTF_8));
                }
                catch (YamlException e) {
                    throw new IllegalStateException("Failed to load YAML file '" + entry.getKey() + "'. Reason:" + e.getMessage(), e);
                }
            }
            return null;
        }
        File path = this.yamlPaths.get(filename);
        if (path == null && (path = this.yamlPaths.get(filename + ".yml")) == null && (path = this.yamlPaths.get(filename + ".yaml")) == null) {
            return null;
        }
        try {
            return Yaml.load((String)Charsets.toString((byte[])this.yamlFiles.get(path), (Charset)Charsets.UTF_8));
        }
        catch (YamlException e) {
            throw new IllegalStateException("Failed to load YAML file '" + path + "'. Reason:" + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Object> getYamlInFolder(String folderName) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        Iterator<Map.Entry<File, byte[]>> iter = this.yamlFiles.entrySet().iterator();
        String fldName = folderName;
        for (File dir : this.dirs) {
            fldName = dir.getAbsolutePath() + File.separatorChar + fldName + File.separatorChar;
            while (iter.hasNext()) {
                Map.Entry<File, byte[]> entry = iter.next();
                String pathName = entry.getKey().getPath();
                if (!pathName.startsWith(fldName)) continue;
                try {
                    retval.put(pathName, Yaml.load((String)Charsets.toString((byte[])entry.getValue(), (Charset)Charsets.UTF_8)));
                }
                catch (YamlException e) {
                    throw new IllegalStateException("Failed to load YAML file '" + pathName + "'. Reason:" + e.getMessage(), e);
                }
            }
        }
        return retval;
    }

    public void reloadConfiguration() {
        LOG.info("Reloading configuration...");
        HashMap<File, Properties> oldPropertiesByFile = new HashMap<File, Properties>(this.propertiesByFile);
        HashMap<File, byte[]> oldXml = new HashMap<File, byte[]>(this.xmlFiles);
        HashMap<File, byte[]> oldYaml = new HashMap<File, byte[]>(this.yamlFiles);
        this.properties.clear();
        this.propertiesByFile.clear();
        this.propertiesFiles.clear();
        this.texts.clear();
        this.yamlFiles.clear();
        this.yamlPaths.clear();
        this.xmlFiles.clear();
        this.loadConfiguration(ConfigurationImpl.getDirectories());
        this.reinitConfigCascade();
        Set<File> changes = this.getChanges(oldPropertiesByFile, oldXml, oldYaml);
        if (changes.isEmpty()) {
            LOG.info("No changes in *.properties, *.xml, *.yaml configuration files detected");
            for (Reloadable reloadable : this.reloadableServices.values()) {
                try {
                    if (!ForcedReloadable.class.isInstance(reloadable)) continue;
                    reloadable.reloadConfiguration(this);
                }
                catch (Exception e) {
                    LOG.warn("Failed to let reloaded configuration be handled by: {}", (Object)reloadable.getClass().getName(), (Object)e);
                }
            }
            return;
        }
        LOG.info("Detected changes in the following configuration files: {}", changes);
        for (Reloadable reloadable : this.reloadableServices.values()) {
            try {
                Map<String, String[]> configFileNames = reloadable.getConfigFileNames();
                if (null == configFileNames || configFileNames.isEmpty()) {
                    reloadable.reloadConfiguration(this);
                    continue;
                }
                boolean doReload = false;
                Iterator<String> it = configFileNames.keySet().iterator();
                while (!doReload && it.hasNext()) {
                    String fileName = it.next();
                    for (File changedFilePath : changes) {
                        if (!changedFilePath.getName().equals(fileName)) continue;
                        doReload = true;
                    }
                }
                if (!doReload) continue;
                reloadable.reloadConfiguration(this);
            }
            catch (Exception e) {
                LOG.warn("Failed to let reloaded configuration be handled by: {}", (Object)reloadable.getClass().getName(), (Object)e);
            }
        }
    }

    private void reinitConfigCascade() {
        ConfigProviderServiceImpl configProvider = this.configProviderServiceImpl;
        boolean reinitMyProvider = true;
        for (ReinitializableConfigProviderService reinit : this.reinitQueue) {
            if (reinit == configProvider) {
                reinitMyProvider = false;
            }
            try {
                reinit.reinit();
                LOG.info("Re-initialized configuration provider for scope \"{}\"", (Object)reinit.getScope());
            }
            catch (Exception e) {
                LOG.warn("Failed to re-initialize configuration provider for scope \"{}\"", (Object)reinit.getScope(), (Object)e);
            }
        }
        if (reinitMyProvider && configProvider != null) {
            try {
                configProvider.reinit();
                LOG.info("Re-initialized configuration provider for scope \"server\"");
            }
            catch (Exception e) {
                LOG.warn("Failed to re-initialize configuration provider for scope \"server\"", (Throwable)e);
            }
        }
    }

    public boolean addReloadable(Reloadable service) {
        if (null != service) {
            return null == this.reloadableServices.putIfAbsent(service.getClass().getName(), service);
        }
        LOG.warn("Tried to add null to reloadable services");
        return false;
    }

    public void removeReloadable(Reloadable service) {
        if (null != service) {
            this.reloadableServices.remove(service.getClass().getName());
        } else {
            LOG.warn("Tried to remove null from reloadable services");
        }
    }

    public void setConfigProviderServiceImpl(ConfigProviderServiceImpl configProviderServiceImpl) {
        this.configProviderServiceImpl = configProviderServiceImpl;
    }

    @NonNull
    private Set<File> getChanges(Map<File, Properties> oldPropertiesByFile, Map<File, byte[]> oldXml, Map<File, byte[]> oldYaml) {
        byte[] oldHash;
        byte[] newHash;
        HashSet<File> result = new HashSet<File>(oldPropertiesByFile.size());
        for (Map.Entry<File, Properties> entry : this.propertiesByFile.entrySet()) {
            File pathname = entry.getKey();
            Properties newProperties = entry.getValue();
            Properties oldProperties = oldPropertiesByFile.get(pathname);
            if (null != oldProperties && newProperties.equals(oldProperties)) continue;
            result.add(pathname);
        }
        HashSet<File> removedFiles = new HashSet<File>(oldPropertiesByFile.keySet());
        removedFiles.removeAll(this.propertiesByFile.keySet());
        result.addAll(removedFiles);
        for (Map.Entry<File, Properties> entry : this.xmlFiles.entrySet()) {
            File file = entry.getKey();
            newHash = (byte[])entry.getValue();
            oldHash = oldXml.get(file);
            if (null != oldHash && Arrays.equals(oldHash, newHash)) continue;
            result.add(file);
        }
        HashSet<File> removedXml = new HashSet<File>(oldXml.keySet());
        removedXml.removeAll(this.xmlFiles.keySet());
        result.addAll(removedXml);
        for (Map.Entry<File, Properties> entry : this.yamlFiles.entrySet()) {
            File filename = entry.getKey();
            newHash = (byte[])entry.getValue();
            oldHash = oldYaml.get(filename);
            if (null != oldHash && Arrays.equals(oldHash, newHash)) continue;
            result.add(filename);
        }
        HashSet<File> removedYaml = new HashSet<File>(oldYaml.keySet());
        removedYaml.removeAll(this.yamlFiles.keySet());
        result.addAll(removedYaml);
        return result;
    }

    public Collection<Reloadable> getReloadables() {
        return this.reloadableServices.values();
    }

    byte[] getHash(File file) {
        byte[] retval = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(this.readFile(file).getBytes());
            retval = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        return retval;
    }

    private static interface FileNameMatcher {
        public boolean matches(String var1, File var2);
    }

    private static final class PropertyFileFilter
    implements FileFilter {
        private final String ext;
        private final String mpasswd;

        PropertyFileFilter() {
            this.ext = ".properties";
            this.mpasswd = "mpasswd";
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(this.ext) || this.mpasswd.equals(pathname.getName());
        }
    }
}

