/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.Behaviour;
import com.openexchange.webdav.action.behaviour.UserAgentBehaviour;
import java.util.HashSet;
import junit.framework.TestCase;

public class UserAgentBehaviourTest
extends TestCase {
    public void testConflict() {
        try {
            new UserAgentBehaviour(".*", new Object[]{new C13(), new C2(), new C123()});
            UserAgentBehaviourTest.fail((String)"Could create conflicting behaviour");
        }
        catch (OXException x) {
            UserAgentBehaviourTest.assertTrue((boolean)true);
        }
    }

    public void testProvides() throws OXException {
        UserAgentBehaviourTest.assertProvides((Behaviour)new UserAgentBehaviour(".*", new Object[]{new C13()}), I1.class, I3.class);
        UserAgentBehaviourTest.assertProvides((Behaviour)new UserAgentBehaviour(".*", new Object[]{new C2()}), I2.class);
        UserAgentBehaviourTest.assertProvides((Behaviour)new UserAgentBehaviour(".*", new Object[]{new C123()}), I1.class, I2.class, I3.class);
        UserAgentBehaviourTest.assertProvides((Behaviour)new UserAgentBehaviour(".*", new Object[]{new C13(), new C2()}), I1.class, I2.class, I3.class);
    }

    public void testMatches() throws OXException {
        MockWebdavRequest req = new MockWebdavRequest(null, "");
        req.setHeader("User-Agent", "Bla");
        UserAgentBehaviourTest.assertTrue((String)"Didn't match!", (boolean)new UserAgentBehaviour("Bl.?", new Object[0]).matches((WebdavRequest)req));
        UserAgentBehaviourTest.assertFalse((String)"Did match!", (boolean)new UserAgentBehaviour("Ab.?", new Object[0]).matches((WebdavRequest)req));
    }

    public void testGet() throws OXException {
        C13 c13 = new C13();
        C2 c2 = new C2();
        UserAgentBehaviour behaviour = new UserAgentBehaviour(".*", new Object[]{c13, c2});
        UserAgentBehaviourTest.assertTrue((c13 == behaviour.get(I1.class) ? 1 : 0) != 0);
        UserAgentBehaviourTest.assertTrue((c13 == behaviour.get(I3.class) ? 1 : 0) != 0);
        UserAgentBehaviourTest.assertTrue((c2 == behaviour.get(I2.class) ? 1 : 0) != 0);
    }

    private static void assertProvides(Behaviour behaviour, Class<? extends Object> ... classes) {
        HashSet copy = new HashSet(behaviour.provides());
        for (Class<? extends Object> clazz : classes) {
            UserAgentBehaviourTest.assertTrue((String)("Didn't find " + clazz), (boolean)copy.remove(clazz));
        }
        UserAgentBehaviourTest.assertTrue((String)copy.toString(), (boolean)copy.isEmpty());
    }

    private static class C123
    extends C13
    implements I2 {
        private C123() {
        }
    }

    private static class C2
    implements I2 {
        private C2() {
        }
    }

    private static class C13
    implements I1,
    I3 {
        private C13() {
        }
    }

    private static interface I3 {
    }

    private static interface I2 {
    }

    private static interface I1 {
    }
}

