/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.transformators.FolderModuleTransformator;
import com.openexchange.test.fixtures.transformators.FolderTypeTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.HashMap;
import java.util.Map;

public class FolderFixtureFactory
implements FixtureFactory<FolderObject> {
    private final FixtureLoader fixtureLoader;

    public FolderFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<FolderObject> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new FolderFixtures(entries, this.fixtureLoader);
    }

    private class FolderFixtures
    extends DefaultFixtures<FolderObject> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<FolderObject>> folders;

        public FolderFixtures(Map<String, Map<String, String>> values, FixtureLoader fixtureLoader) {
            super(FolderObject.class, values, fixtureLoader);
            this.folders = new HashMap<String, Fixture<FolderObject>>();
            this.addTransformator((Transformator)new FolderModuleTransformator(), "module");
            this.addTransformator((Transformator)new FolderTypeTransformator(), "type");
            this.entries = values;
        }

        @Override
        public Fixture<FolderObject> getEntry(String entryName) throws OXException {
            if (this.folders.containsKey(entryName)) {
                return this.folders.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            FolderObject folder = new FolderObject();
            this.apply(folder, values);
            Fixture<FolderObject> fixture = new Fixture<FolderObject>(folder, values.keySet().toArray(new String[values.size()]), values);
            this.folders.put(entryName, fixture);
            return fixture;
        }
    }
}

