/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import com.openexchange.mail.mime.MessageHeaders;
import java.util.Random;
import org.junit.After;
import org.junit.Before;

public final class MailAppendTest
extends MessageStorageTest {
    private static final String INBOX = "INBOX";
    private String[] uids = null;
    private static MailField[][] variations = null;
    private final MailField[] fieldWithoutUidFolderAndFlags = new MailField[]{MailField.CONTENT_TYPE, MailField.FROM, MailField.TO, MailField.CC, MailField.BCC, MailField.SUBJECT, MailField.SIZE, MailField.SENT_DATE, MailField.THREAD_LEVEL, MailField.DISPOSITION_NOTIFICATION_TO, MailField.PRIORITY, MailField.COLOR_LABEL, MailField.HEADERS, MailField.BODY};
    private final MailField[] fieldsfull = new MailField[]{MailField.FULL};

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testMailAppendAndDeleteMails() throws OXException {
        this.uids = this.mailAccess.getMessageStorage().appendMessages(INBOX, this.testmessages);
        this.mailAccess.getMessageStorage().deleteMessages(INBOX, this.uids, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAppendAndGetOneMessage() throws OXException {
        this.uids = this.mailAccess.getMessageStorage().appendMessages(INBOX, new MailMessage[]{this.testmessages[0]});
        try {
            MailMessage m = this.mailAccess.getMessageStorage().getMessage(INBOX, this.uids[0], true);
            m.removeHeader(MessageHeaders.HDR_X_OX_MARKER);
            this.compareMailMessages(this.testmessages[0], m, this.fieldWithoutUidFolderAndFlags, this.fieldsfull, "test message", "fetched message", true);
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages(INBOX, this.uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAppendAndGetMessage() throws OXException {
        this.uids = this.mailAccess.getMessageStorage().appendMessages(INBOX, this.testmessages);
        try {
            for (int i = 0; i < this.uids.length; ++i) {
                MailMessage m = this.mailAccess.getMessageStorage().getMessage(INBOX, this.uids[i], true);
                m.removeHeader(MessageHeaders.HDR_X_OX_MARKER);
                this.compareMailMessages(this.testmessages[i], m, this.fieldWithoutUidFolderAndFlags, this.fieldsfull, "test message", "fetched message", true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages(INBOX, this.uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAppendAndGetMessages() throws OXException {
        this.uids = this.mailAccess.getMessageStorage().appendMessages(INBOX, this.testmessages);
        try {
            for (int k = 0; k < MailField.values().length; ++k) {
                MailField[] fields = variations[k];
                MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(INBOX, this.uids, fields);
                MailAppendTest.assertTrue((String)"The size of the uids is not equal with the size of the fetched mails which is returned from the getMessages method", (fetchedMails.length == this.uids.length ? 1 : 0) != 0);
                for (int i = 0; i < fetchedMails.length; ++i) {
                    fetchedMails[i].removeHeader(MessageHeaders.HDR_X_OX_MARKER);
                    this.compareMailMessages(this.testmessages[i], fetchedMails[i], this.fieldWithoutUidFolderAndFlags, fields, "test messages", "fetched messages " + i, true);
                }
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages(INBOX, this.uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAppendAndGetMessagesRandomFields() throws OXException {
        this.uids = this.mailAccess.getMessageStorage().appendMessages(INBOX, this.testmessages);
        try {
            Random random = new Random();
            int length = MailField.values().length;
            int nextInt = random.nextInt(variations.length - length) + length;
            MailField[] fields = variations[nextInt];
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(INBOX, this.uids, fields);
            MailAppendTest.assertTrue((String)"The size of the uids is not equal with the size of the fetched mails which is returned from the getMessages method", (fetchedMails.length == this.uids.length ? 1 : 0) != 0);
            for (int i = 0; i < fetchedMails.length; ++i) {
                fetchedMails[i].removeHeader(MessageHeaders.HDR_X_OX_MARKER);
                this.compareMailMessages(this.testmessages[i], fetchedMails[i], this.fieldWithoutUidFolderAndFlags, fields, "test messages", "fetched messages " + i, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages(INBOX, this.uids, true);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.mailAccess.close(false);
        super.tearDown();
    }

    static {
        variations = MailAppendTest.generateVariations();
    }
}

