/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.search.impl.SearchEngineImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.test.TestInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class SearchEngineTest
extends TestCase {
    private SearchEngineImpl searchEngine;
    private Context ctx = null;
    private User user = null;
    private int folderId;
    private ServerSession session;
    private List<DocumentMetadata> clean;
    private DBProvider provider = null;
    private InfostoreFacade infostore = null;

    public void setUp() throws Exception {
        this.clean = new ArrayList<DocumentMetadata>();
        TestInit.loadTestProperties();
        Init.startServer();
        ContextStorage ctxstor = ContextStorage.getInstance();
        int contextId = ctxstor.getContextId("defaultcontext");
        this.ctx = ctxstor.getContext(contextId);
        this.user = UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId("thorben", this.ctx), this.ctx);
        this.session = ServerSessionFactory.createServerSession(this.user.getId(), this.ctx, "blupp");
        this.folderId = this._getPrivateInfostoreFolder(this.ctx, this.user, this.session);
        this.provider = new DBPoolProvider();
        this.searchEngine = new SearchEngineImpl(this.provider);
        this.infostore = new InfostoreFacadeImpl(this.provider);
    }

    public int _getPrivateInfostoreFolder(Context context, User usr, ServerSession sess) throws OXException {
        OXFolderAccess oxfa = new OXFolderAccess(context);
        return oxfa.getDefaultFolder(usr.getId(), 8).getObjectID();
    }

    public void testRequestedFieldOrderMayVary() {
        this.assertSurvivesOrder(new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.ID_LITERAL, Metadata.TITLE_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL, Metadata.ID_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL});
    }

    public void testSearchForPercent() throws OXException, OXException {
        DocumentMetadata doc1 = this.createWithTitle("100%");
        this.createWithTitle("Hallo");
        List<Integer> folderIDs = Collections.singletonList(this.folderId);
        SearchIterator iter = this.searchEngine.search(this.session, "%", folderIDs, Collections.emptyList(), new Metadata[]{Metadata.ID_LITERAL, Metadata.TITLE_LITERAL}, Metadata.TITLE_LITERAL, 1, 0, 10);
        List documents = SearchIterators.asList((SearchIterator)iter);
        SearchEngineTest.assertTrue((0 < documents.size() ? 1 : 0) != 0);
        boolean found = false;
        for (DocumentMetadata document : documents) {
            SearchEngineTest.assertTrue((null != document.getTitle() && document.getTitle().contains("%") ? 1 : 0) != 0);
            if (!doc1.getTitle().equals(document.getTitle())) continue;
            found = true;
        }
        SearchEngineTest.assertTrue((boolean)found);
    }

    private DocumentMetadata createWithTitle(String title) throws OXException {
        DocumentMetadataImpl metadata = new DocumentMetadataImpl();
        metadata.setTitle(title);
        metadata.setFolderId((long)this.folderId);
        try {
            this.infostore.startTransaction();
            this.infostore.saveDocumentMetadata((DocumentMetadata)metadata, -1L, this.session);
            this.infostore.commit();
            this.clean.add((DocumentMetadata)metadata);
        }
        catch (OXException x) {
            try {
                this.infostore.rollback();
            }
            catch (OXException e) {
                e.printStackTrace();
            }
            throw x;
        }
        finally {
            try {
                this.infostore.finish();
            }
            catch (OXException e) {
                e.printStackTrace();
            }
        }
        return metadata;
    }

    private void assertSurvivesOrder(Metadata[] metadata) {
        List<Integer> folderIDs = Collections.singletonList(this.folderId);
        try {
            this.searchEngine.search(this.session, "*", folderIDs, Collections.emptyList(), metadata, metadata[0], 1, 0, 10);
        }
        catch (Exception x) {
            SearchEngineTest.fail((String)x.getMessage());
            x.printStackTrace();
        }
    }
}

