/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.calendar.CalendarAdministration;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.groupware.AppointmentBugTests;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.test.AjaxInit;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;

public class CalendarDeleteTest
extends TestCase {
    private static int contextid = 1;
    private static int userid = 11;
    private static int groupid = 62;
    private static int resourceid = 2;
    private static int deleteuserid = 11;
    private Context context;
    private static boolean init = false;

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        contextid = ContextStorage.getInstance().getContextId("defaultcontext");
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        this.context = new ContextImpl(contextid);
        userid = CalendarTest.getUserId();
        String user2 = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"user_participant3", (String)"");
        deleteuserid = this.resolveUser(user2);
        try {
            CalendarTest ct = new CalendarTest();
            CalendarTest.dontDelete();
            ct.setUp();
            ct.testWholeDayWithDB();
            ct.testMultiSpanWholeDay();
            ct.testInsertAndLabel();
            ct.testNoAlarm();
            ct.testInsertAndAlarm();
            ct.testConfirmation();
            ct.testInsertUpdateAlarm();
            ct.testAlarmAndUpdate();
            AppointmentBugTests abt = new AppointmentBugTests();
            abt.testBug4467();
            abt.testBug4276();
            abt.testBug4766();
            abt.testBug5010();
            abt.testBug5012();
        }
        catch (Throwable ex) {
            throw new Exception(ex.getMessage(), ex);
        }
        finally {
            CalendarTest.doDelete();
        }
    }

    private Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private int resolveUser(String user) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(user, this.context);
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    public void testDeleteUserData() throws Throwable {
        Connection readcon = DBPool.pickup((Context)this.context);
        Connection writecon = DBPool.pickupWriteable((Context)this.context);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)deleteuserid, (int)this.context.getContextId(), (String)"deleteAllUserApps");
        DeleteEvent delEvent = new DeleteEvent((Object)this, so.getUserId(), 1, ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarAdministration ca = new CalendarAdministration();
        ca.deletePerformed(delEvent, readcon, writecon);
        Statement stmt = readcon.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd, prg_dates_members pdm WHERE pd.intfield01 = pdm.object_id AND pdm.member_uid = " + deleteuserid + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no appointment exists for user " + deleteuserid), (!rs.next() ? 1 : 0) != 0);
        rs.close();
        ResultSet rs2 = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd WHERE pd.created_from = " + deleteuserid + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no cerated_from exists for user " + deleteuserid), (!rs2.next() ? 1 : 0) != 0);
        rs2.close();
        ResultSet rs3 = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd WHERE pd.changed_from = " + deleteuserid + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no changed_from exists for user " + deleteuserid), (!rs3.next() ? 1 : 0) != 0);
        rs3.close();
        ResultSet rs4 = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd, prg_date_rights pdr WHERE pd.intfield01 = pdr.object_id AND pdr.id = " + deleteuserid + " AND pdr.type = " + 1 + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no user_right entry exists for user " + deleteuserid), (!rs4.next() ? 1 : 0) != 0);
        rs4.close();
        stmt.close();
        DBPool.push((Context)this.context, (Connection)readcon);
        DBPool.pushWrite((Context)this.context, (Connection)writecon);
    }

    public void testDeleteGroup() throws Throwable {
        Connection readcon = DBPool.pickup((Context)this.context);
        Connection writecon = DBPool.pickupWriteable((Context)this.context);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)deleteuserid, (int)this.context.getContextId(), (String)"deleteAllUserApps");
        DeleteEvent delEvent = new DeleteEvent((Object)this, groupid, 2, ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarAdministration ca = new CalendarAdministration();
        ca.deletePerformed(delEvent, readcon, writecon);
        Statement stmt = readcon.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd, prg_date_rights pdr WHERE pd.intfield01 = pdr.object_id AND pdr.id = " + groupid + " AND pdr.type = " + 2 + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no user_right entry exists for group " + deleteuserid), (!rs.next() ? 1 : 0) != 0);
        rs.close();
        stmt.close();
        DBPool.push((Context)this.context, (Connection)readcon);
        DBPool.pushWrite((Context)this.context, (Connection)writecon);
    }

    public void testDeleteResource() throws Throwable {
        Connection readcon = DBPool.pickup((Context)this.context);
        Connection writecon = DBPool.pickupWriteable((Context)this.context);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)deleteuserid, (int)this.context.getContextId(), (String)"deleteAllUserApps");
        DeleteEvent delEvent = new DeleteEvent((Object)this, resourceid, 3, ContextStorage.getInstance().getContext(so.getContextId()));
        CalendarAdministration ca = new CalendarAdministration();
        ca.deletePerformed(delEvent, readcon, writecon);
        Statement stmt = readcon.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT pd.intfield01 from prg_dates pd, prg_date_rights pdr WHERE pd.intfield01 = pdr.object_id AND pdr.id = " + resourceid + " AND pdr.type = " + 3 + " AND pd.cid = " + contextid);
        CalendarDeleteTest.assertTrue((String)("Test that no user_right entry exists for resource " + deleteuserid), (!rs.next() ? 1 : 0) != 0);
        rs.close();
        stmt.close();
        DBPool.push((Context)this.context, (Connection)readcon);
        DBPool.pushWrite((Context)this.context, (Connection)writecon);
    }
}

