/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BulkImportTest
extends CardDAVTest {
    @Test
    public void testBulkImportWithSimilarityCheck() throws Exception {
        String syncToken = super.fetchSyncToken();
        String firstName = "test";
        String lastName = "horst";
        String uid = UUID.nameUUIDFromBytes("testhorst_bulk_contact".getBytes()).toString();
        String firstName2 = "test2";
        String lastName2 = "horst2";
        String uid2 = UUID.nameUUIDFromBytes("test2horst2_bulk_contact".getBytes()).toString();
        String firstName3 = "test3";
        String lastName3 = "horst3";
        String uid3 = UUID.nameUUIDFromBytes("test3horst3_bulk_contact".getBytes()).toString();
        String email1 = uid + "@domain.com";
        String email2 = uid2 + "@domain.com";
        String vCard1 = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst;test;;;\r\nFN:test horst\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:" + email1 + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        String vCard2 = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst2;test2;;;\r\nFN:test2 horst2\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:" + email2 + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid2 + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        String vCard3 = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst3;test3;;;\r\nFN:test3 horst3\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:" + email1 + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid3 + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        String vCard = vCard2 + vCard3;
        super.delete(uid);
        super.delete(uid2);
        String xmlResponse = super.postVCard(uid, vCard1, 0.0f);
        Document xmlDoc = BulkImportTest.loadXMLFromString(xmlResponse);
        NodeList list = xmlDoc.getElementsByTagName("D:href");
        Assert.assertEquals((String)"Unexpected href count", (long)1L, (long)list.getLength());
        Node node = list.item(0);
        String hrefContent = node.getTextContent();
        Assert.assertNotNull((String)"Response does not contain a href", (Object)hrefContent);
        Assert.assertTrue((String)"Response does not contain a href", (!hrefContent.isEmpty() ? 1 : 0) != 0);
        xmlResponse = super.postVCard(uid, vCard, 1.0f);
        xmlDoc = BulkImportTest.loadXMLFromString(xmlResponse);
        list = xmlDoc.getElementsByTagName("D:href");
        Assert.assertEquals((String)"Unexpected href count", (long)3L, (long)list.getLength());
        node = list.item(0);
        hrefContent = node.getTextContent();
        Assert.assertNotNull((String)"Response does not contain a href", (Object)hrefContent);
        Assert.assertTrue((String)"Response does not contain a href", (!hrefContent.isEmpty() ? 1 : 0) != 0);
        node = list.item(1);
        hrefContent = node.getTextContent();
        Assert.assertTrue((String)"Response does contain a href, but it shouldn't", (hrefContent == null || hrefContent.isEmpty() ? 1 : 0) != 0);
        NodeList noSimilarContacts = xmlDoc.getElementsByTagName("OX:no-similar-contact");
        Assert.assertEquals((String)"Unexpected no-similar-contact count", (long)1L, (long)noSimilarContacts.getLength());
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"horst", (Object)contact.getSurName());
        Contact contact2 = super.getContact(uid2);
        super.rememberForCleanUp(contact2);
        Assert.assertEquals((String)"uid wrong", (Object)uid2, (Object)contact2.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test2", (Object)contact2.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"horst2", (Object)contact2.getSurName());
        Contact contact3 = super.getContact(uid3);
        Assert.assertNull((String)"Contact3 is not null", (Object)contact3);
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = BulkImportTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"test", (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"horst", (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"test horst", (Object)card.getFN());
        VCardResource card2 = BulkImportTest.assertContains(uid2, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"test2", (Object)card2.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"horst2", (Object)card2.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"test2 horst2", (Object)card2.getFN());
        BulkImportTest.assertNotContains(uid3, addressData);
    }

    private static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }
}

