/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug37112Test
extends CalDAVTest {
    private FolderObject publicFolder = null;
    private String publicFolderID = null;

    @Before
    public void setUp() throws Exception {
        this.publicFolder = this.createPublicFolder();
        this.publicFolderID = String.valueOf(this.publicFolder.getObjectID());
    }

    @Test
    public void testCreateExceptionInClient() throws Exception {
        String uid = Bug37112Test.randomUID();
        Date start = TimeTools.D("next monday at 12:00");
        Date end = TimeTools.D("next monday at 13:00");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, 7);
        Date until = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nX-LIC-LOCATION:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:testserie" + "\r\n" + "RRULE:FREQ=DAILY;UNTIL=" + Bug37112Test.formatAsUTC(until) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug37112Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug37112Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 2);
        Date exceptionEnd = calendar.getTime();
        String iCalException = "BEGIN:VEVENT\r\nCREATED:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + Bug37112Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:testserie edit" + "\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + Bug37112Test.format(exceptionStart, "Europe/Berlin") + "\r\n" + iCalResource.getVEvent().getProperty("ORGANIZER").toString() + "\r\n" + iCalResource.getVEvent().getProperty("ATTENDEE").toString() + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug37112Test.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug37112Test.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "SEQUENCE:1" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "X-MOZ-GENERATION:1" + "\r\n" + "END:VEVENT";
        iCalResource.addComponent(SimpleICal.parse(iCalException, "VEVENT"));
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = this.getAppointment(this.publicFolderID, uid);
        Assert.assertNotNull((String)"Appointment not found on server", (Object)appointment);
        Assert.assertNotNull((String)"No chnage exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        iCalResource = this.get(this.publicFolderID, uid, null);
        Assert.assertNotNull((String)"No VEVENTs in iCal found", iCalResource.getVEvents());
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
    }
}

