/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug29728Test
extends CalDAVTest {
    @Test
    public void testCreateSeriesWithDeleteExceptions() throws Exception {
        String uid = Bug29728Test.randomUID();
        Date start = TimeTools.D("next friday at 8:00");
        Date end = TimeTools.D("next thursday at 10:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(start);
        calendar.add(3, 2);
        Date ex1 = calendar.getTime();
        calendar.add(3, 2);
        Date ex2 = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nX-LIC-LOCATION:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + Bug29728Test.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + Bug29728Test.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + Bug29728Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "SUMMARY:serie\r\n" + "RRULE:FREQ=DAILY\r\n" + "EXDATE:" + Bug29728Test.formatAsUTC(ex1) + "\r\n" + "EXDATE:" + Bug29728Test.formatAsUTC(ex2) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug29728Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug29728Test.format(end, "Europe/Berlin") + "\r\n" + "LOCATION:da\r\n" + "SEQUENCE:2\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
    }
}

