/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.ICalUtils;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug22395Test
extends CalDAVTest {
    @Test
    public void testDateOfChangeExceptions() throws Exception {
        Date expectedEnd;
        Date expectedStart;
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("Tomorrow at midnight", TimeZone.getTimeZone("Europe/Berlin")));
        for (int i = 0; i < 24; ++i) {
            Appointment appointment = new Appointment();
            appointment.setUid(Bug22395Test.randomUID());
            appointment.setTitle("Series " + i);
            appointment.setIgnoreConflicts(true);
            appointment.setStartDate(calendar.getTime());
            calendar.add(11, 1);
            appointment.setEndDate(calendar.getTime());
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            super.create(appointment);
            appointments.add(appointment);
        }
        Date clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22395Test.assertContains(appointment.getUid(), calendarData);
            Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)iCalResource.getVEvent().getSummary());
            Assert.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)iCalResource.getVEvent().getDTStart());
            Assert.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)iCalResource.getVEvent().getDTEnd());
        }
        for (ICalResource iCalResource : calendarData) {
            SimpleICal.Component exception = new SimpleICal.Component("VEVENT");
            exception.setProperty("CREATED", Bug22395Test.formatAsUTC(new Date()));
            exception.setProperty("UID", iCalResource.getVEvent().getUID());
            String tzID = iCalResource.getVEvent().getProperty("DTSTART").getAttribute("TZID");
            calendar.setTime(iCalResource.getVEvent().getDTStart());
            calendar.add(6, 2);
            Date exceptionStart = calendar.getTime();
            HashMap<String, String> tzIDAttributes = new HashMap<String, String>();
            tzIDAttributes.put("TZID", tzID);
            exception.setProperty("DTSTART", ICalUtils.format(exceptionStart, tzID), tzIDAttributes);
            calendar.setTime(iCalResource.getVEvent().getDTEnd());
            calendar.add(6, 2);
            Date exceptionEnd = calendar.getTime();
            exception.setProperty("DTEND", ICalUtils.format(exceptionEnd, tzID), tzIDAttributes);
            exception.setProperty("TRANSP", "OPAQUE");
            exception.setProperty("SUMMARY", iCalResource.getVEvent().getPropertyValue("SUMMARY") + "_edit");
            exception.setProperty("DTSTAMP", Bug22395Test.formatAsUTC(new Date()));
            exception.setProperty("SEQUENCE", "3");
            exception.setProperty("RECURRENCE-ID", ICalUtils.format(exceptionStart, tzID), tzIDAttributes);
            iCalResource.addComponent(exception);
            Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        }
        List<Appointment> updates = super.getManager().updates(Bug22395Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Assert.assertNotNull((String)"no updates found on server", updates);
        Assert.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        for (Appointment appointment : appointments) {
            calendar.setTime(appointment.getStartDate());
            calendar.add(6, 2);
            expectedStart = calendar.getTime();
            calendar.setTime(appointment.getEndDate());
            calendar.add(6, 2);
            expectedEnd = calendar.getTime();
            Appointment exception = null;
            for (Appointment update : updates) {
                if (appointment.getObjectID() == update.getObjectID() || !appointment.getUid().equals(update.getUid())) continue;
                exception = update;
                break;
            }
            Assert.assertNotNull((String)"Exception not found", exception);
            Assert.assertEquals((String)"Title wrong", (Object)(appointment.getTitle() + "_edit"), (Object)exception.getTitle());
            Assert.assertEquals((String)"Start date wrong", (Object)expectedStart, (Object)exception.getStartDate());
            Assert.assertEquals((String)"End date wrong", (Object)expectedEnd, (Object)exception.getEndDate());
            Assert.assertEquals((String)"Recurrence date position wrong", (long)3L, (long)exception.getRecurrencePosition());
        }
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            calendar.setTime(appointment.getStartDate());
            calendar.add(6, 2);
            expectedStart = calendar.getTime();
            calendar.setTime(appointment.getEndDate());
            calendar.add(6, 2);
            expectedEnd = calendar.getTime();
            ICalResource iCalResource = Bug22395Test.assertContains(appointment.getUid(), calendarData);
            Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Assert.assertEquals((String)"No exception found in iCal", (long)2L, (long)iCalResource.getVEvents().size());
            for (SimpleICal.Component vEvent : iCalResource.getVEvents()) {
                Date recurrenceID = vEvent.getRecurrenceID();
                if (null != recurrenceID) {
                    Assert.assertEquals((String)"SUMMARY wrong", (Object)(appointment.getTitle() + "_edit"), (Object)vEvent.getSummary());
                    Assert.assertEquals((String)"DTSTART wrong", (Object)expectedStart, (Object)vEvent.getDTStart());
                    Assert.assertEquals((String)"DTEND wrong", (Object)expectedEnd, (Object)vEvent.getDTEnd());
                    Assert.assertEquals((String)"RECURRENCE-ID wrong", (Object)expectedStart, (Object)recurrenceID);
                    continue;
                }
                Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)vEvent.getSummary());
                Assert.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)vEvent.getDTStart());
                Assert.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)vEvent.getDTEnd());
            }
        }
    }
}

