/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.WebDAVClient;
import com.openexchange.dav.reports.SyncCollectionReportInfo;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.json.JSONException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public abstract class JUnit3WebDAVTest
extends AbstractAJAXSession {
    protected static final int TIMEOUT = 10000;
    private List<FolderObject> foldersToCleanUp;
    private Map<Long, WebDAVClient> webDAVClients;

    public JUnit3WebDAVTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.webDAVClients = new HashMap<Long, WebDAVClient>();
        this.getAJAXClient().setHostname(JUnit3WebDAVTest.getHostname());
        this.getAJAXClient().setProtocol(JUnit3WebDAVTest.getProtocol());
        this.foldersToCleanUp = new ArrayList<FolderObject>();
    }

    @Override
    protected void tearDown() throws Exception {
        this.cleanupFolders();
        super.tearDown();
    }

    protected abstract String getDefaultUserAgent();

    protected WebDAVClient getWebDAVClient() throws OXException {
        Long threadID = Thread.currentThread().getId();
        if (!this.webDAVClients.containsKey(threadID)) {
            WebDAVClient webDAVClient = new WebDAVClient(this.getDefaultUserAgent());
            this.webDAVClients.put(threadID, webDAVClient);
            return webDAVClient;
        }
        return this.webDAVClients.get(threadID);
    }

    private void cleanupFolders() {
        if (null != this.foldersToCleanUp) {
            for (FolderObject folder : this.foldersToCleanUp) {
                try {
                    this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, folder.getObjectID(), new Date()));
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    protected void rememberForCleanUp(FolderObject folder) {
        this.foldersToCleanUp.add(folder);
    }

    protected FolderObject getFolder(String folderName) throws OXException, IOException, JSONException {
        VisibleFoldersResponse response = this.client.execute(new VisibleFoldersRequest(EnumAPI.OX_NEW, "contacts", new int[]{1, 300}));
        FolderObject folder = JUnit3WebDAVTest.findByName(response.getPrivateFolders(), folderName);
        if (null == folder && null == (folder = JUnit3WebDAVTest.findByName(response.getPublicFolders(), folderName))) {
            folder = JUnit3WebDAVTest.findByName(response.getSharedFolders(), folderName);
        }
        if (null != folder) {
            folder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, folder.getObjectID())).getFolder();
        }
        return folder;
    }

    protected FolderObject getCalendarFolder(String folderName) throws OXException, IOException, JSONException {
        VisibleFoldersResponse response = this.client.execute(new VisibleFoldersRequest(EnumAPI.OX_NEW, "calendar", new int[]{1, 300}));
        FolderObject folder = JUnit3WebDAVTest.findByName(response.getPrivateFolders(), folderName);
        if (null == folder && null == (folder = JUnit3WebDAVTest.findByName(response.getPublicFolders(), folderName))) {
            folder = JUnit3WebDAVTest.findByName(response.getSharedFolders(), folderName);
        }
        if (null != folder) {
            folder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, folder.getObjectID())).getFolder();
        }
        return folder;
    }

    private static FolderObject findByName(Iterator<FolderObject> iter, String folderName) {
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (!folderName.equals(folder.getFolderName())) continue;
            return folder;
        }
        return null;
    }

    protected boolean removeFromETags(Map<String, String> eTags, String uid) {
        String href = this.getHrefFromETags(eTags, uid);
        if (null != href) {
            eTags.remove(href);
            return true;
        }
        return false;
    }

    protected String getHrefFromETags(Map<String, String> eTags, String uid) {
        for (String href : eTags.keySet()) {
            if (!href.contains(uid)) continue;
            return href;
        }
        return null;
    }

    protected List<String> getChangedHrefs(Map<String, String> previousETags, Map<String, String> newETags) {
        ArrayList<String> hrefs = new ArrayList<String>();
        for (String href : newETags.keySet()) {
            if (previousETags.containsKey(href) && newETags.get(href).equals(newETags.get(href))) continue;
            hrefs.add(href);
        }
        return hrefs;
    }

    protected FolderObject createFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new InsertRequest((API)EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.rememberForCleanUp(folder);
        return folder;
    }

    protected FolderObject updateFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new UpdateRequest((API)EnumAPI.OX_NEW, folder));
        folder.setLastModified(response.getTimestamp());
        return folder;
    }

    protected FolderObject getFolder(int folderID) throws OXException, IOException, JSONException {
        return this.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, folderID)).getFolder();
    }

    protected void deleteFolder(FolderObject folder) throws OXException, IOException, JSONException {
        this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, true, folder));
    }

    protected FolderObject createFolder(FolderObject parent, String folderName) throws OXException, IOException, JSONException {
        FolderObject folder = new FolderObject();
        folder.setFolderName(folderName);
        folder.setParentFolderID(parent.getObjectID());
        folder.setModule(parent.getModule());
        folder.setType(parent.getType());
        folder.setPermissions(parent.getPermissions());
        return this.createFolder(folder);
    }

    protected static String getBaseUri() throws OXException {
        return JUnit3WebDAVTest.getProtocol() + "://" + JUnit3WebDAVTest.getHostname();
    }

    protected static AJAXClient.User getUser() {
        return AJAXClient.User.User1;
    }

    protected static String getLogin() throws OXException {
        return JUnit3WebDAVTest.getLogin(JUnit3WebDAVTest.getUser());
    }

    protected static String getusername() throws OXException {
        return JUnit3WebDAVTest.getUsername(JUnit3WebDAVTest.getUser());
    }

    protected static String getPassword() throws OXException {
        return JUnit3WebDAVTest.getPassword(JUnit3WebDAVTest.getUser());
    }

    protected static String getHostname() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.HOSTNAME.getPropertyName()});
        }
        return hostname;
    }

    protected static String getProtocol() throws OXException {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL);
        if (null == hostname) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.PROTOCOL.getPropertyName()});
        }
        return hostname;
    }

    protected static String getLogin(AJAXClient.User user) throws OXException {
        String login = AJAXConfig.getProperty(user.getLogin());
        if (null == login) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        if (login.contains("@")) {
            return login;
        }
        String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        if (null == context) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.CONTEXTNAME.getPropertyName()});
        }
        return login + "@" + context;
    }

    protected static String getUsername(AJAXClient.User user) throws OXException {
        String username = AJAXConfig.getProperty(user.getLogin());
        if (null == username) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        return username.contains("@") ? username.substring(0, username.indexOf("@")) : username;
    }

    protected static String getPassword(AJAXClient.User user) throws OXException {
        String password = AJAXConfig.getProperty(user.getPassword());
        if (null == password) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getPassword().getPropertyName()});
        }
        return password;
    }

    protected static void release(HttpMethodBase method) {
        if (null != method) {
            method.releaseConnection();
        }
    }

    protected static String randomUID() {
        return UUID.randomUUID().toString();
    }

    protected AJAXClient getAJAXClient() {
        return super.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchSyncToken(String relativeUrl) throws OXException, IOException, DavException {
        String string;
        PropFindMethod propFind = null;
        try {
            DavPropertyNameSet props = new DavPropertyNameSet();
            props.add(PropertyNames.SYNC_TOKEN);
            propFind = new PropFindMethod(JUnit3WebDAVTest.getBaseUri() + relativeUrl, 0, props, 0);
            MultiStatusResponse response = JUnit3WebDAVTest.assertSingleResponse(this.getWebDAVClient().doPropFind(propFind, 207));
            string = this.extractTextContent(PropertyNames.SYNC_TOKEN, response);
        }
        catch (Throwable throwable) {
            JUnit3WebDAVTest.release(propFind);
            throw throwable;
        }
        JUnit3WebDAVTest.release((HttpMethodBase)propFind);
        return string;
    }

    protected Map<String, String> syncCollection(String syncToken, String relativeUrl) throws OXException, IOException, DavException {
        MultiStatusResponse[] responses;
        HashMap<String, String> eTags = new HashMap<String, String>();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        SyncCollectionReportInfo reportInfo = new SyncCollectionReportInfo(syncToken, props);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doReport((ReportInfo)reportInfo, JUnit3WebDAVTest.getBaseUri() + relativeUrl)) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            JUnit3WebDAVTest.assertNotNull((String)"got no href from response", (Object)href);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            JUnit3WebDAVTest.assertNotNull((String)"got no ETag from response", (Object)eTag);
            eTags.put(href, eTag);
        }
        return eTags;
    }

    protected SyncCollectionResponse syncCollection(SyncToken syncToken, String relativeUrl) throws OXException, IOException, DavException {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        SyncCollectionReportInfo reportInfo = new SyncCollectionReportInfo(syncToken.getToken(), props);
        SyncCollectionResponse syncCollectionResponse = this.getWebDAVClient().doReport(reportInfo, JUnit3WebDAVTest.getBaseUri() + relativeUrl);
        syncToken.setToken(syncCollectionResponse.getSyncToken());
        return syncCollectionResponse;
    }

    protected String extractHref(DavPropertyName propertyName, MultiStatusResponse response) {
        Node node = this.extractNodeValue(propertyName, response);
        JUnit3WebDAVTest.assertMatches(PropertyNames.HREF, node);
        String content = node.getTextContent();
        JUnit3WebDAVTest.assertNotNull((String)("no text content in " + PropertyNames.HREF + " child for " + propertyName), (Object)content);
        return content;
    }

    protected Node extractNodeValue(DavPropertyName propertyName, MultiStatusResponse response) {
        JUnit3WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        JUnit3WebDAVTest.assertTrue((String)("value is not a node in " + propertyName), (boolean)(value instanceof Node));
        return (Node)value;
    }

    protected List<Node> extractNodeListValue(DavPropertyName propertyName, MultiStatusResponse response) {
        JUnit3WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        JUnit3WebDAVTest.assertTrue((String)("value is not a node list in " + propertyName), (boolean)(value instanceof List));
        return (List)value;
    }

    protected DavProperty<?> extractProperty(DavPropertyName propertyName, MultiStatusResponse response) {
        JUnit3WebDAVTest.assertNotEmpty(propertyName, response);
        DavProperty property = response.getProperties(200).get(propertyName);
        JUnit3WebDAVTest.assertNotNull((String)("property " + propertyName + " not found"), (Object)property);
        return property;
    }

    protected String extractTextContent(DavPropertyName propertyName, MultiStatusResponse response) {
        JUnit3WebDAVTest.assertNotEmpty(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        JUnit3WebDAVTest.assertTrue((String)("value is not a string in " + propertyName), (boolean)(value instanceof String));
        return (String)value;
    }

    protected static String extractChildTextContent(DavPropertyName propertyName, Element element) {
        NodeList nodes = element.getElementsByTagNameNS(propertyName.getNamespace().getURI(), propertyName.getName());
        JUnit3WebDAVTest.assertNotNull((String)"no child elements found by property name", (Object)nodes);
        JUnit3WebDAVTest.assertEquals((String)"0 or more than one child nodes found for property", (int)1, (int)nodes.getLength());
        Node node = nodes.item(0);
        JUnit3WebDAVTest.assertNotNull((String)"no child element found by property name", (Object)node);
        return node.getTextContent();
    }

    protected static String formatAsUTC(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    protected static String formatAsDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static void assertMatches(DavPropertyName propertyName, Node node) {
        JUnit3WebDAVTest.assertEquals((String)"wrong element name", (String)propertyName.getName(), (String)node.getLocalName());
        JUnit3WebDAVTest.assertEquals((String)"wrong element namespace", (String)propertyName.getNamespace().getURI(), (String)node.getNamespaceURI());
    }

    public static void assertContains(DavPropertyName propertyName, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!propertyName.getName().equals(node.getLocalName()) || !propertyName.getNamespace().getURI().equals(node.getNamespaceURI())) continue;
            return;
        }
        JUnit3WebDAVTest.fail((String)("property " + propertyName + " not found in list"));
    }

    public static void assertIsPresent(DavPropertyName propertyName, MultiStatusResponse response) {
        DavProperty property = response.getProperties(200).get(propertyName);
        JUnit3WebDAVTest.assertNotNull((String)("property " + propertyName + " not found"), (Object)property);
    }

    public static void assertNotEmpty(DavPropertyName propertyName, MultiStatusResponse response) {
        JUnit3WebDAVTest.assertIsPresent(propertyName, response);
        Object value = response.getProperties(200).get(propertyName).getValue();
        JUnit3WebDAVTest.assertNotNull((String)("no value for " + propertyName), (Object)value);
    }

    public static MultiStatusResponse assertSingleResponse(MultiStatusResponse[] responses) {
        JUnit3WebDAVTest.assertNotNull((String)"got no multistatus responses", (Object)responses);
        JUnit3WebDAVTest.assertTrue((String)"got zero multistatus responses", (0 < responses.length ? 1 : 0) != 0);
        JUnit3WebDAVTest.assertTrue((String)"got more than one multistatus responses", (1 == responses.length ? 1 : 0) != 0);
        MultiStatusResponse response = responses[0];
        JUnit3WebDAVTest.assertNotNull((String)"no multistatus response", (Object)response);
        return response;
    }

    public static void assertResponseHeaders(String[] expected, String headerName, HttpMethod method) {
        for (String expectedHeader : expected) {
            boolean found = false;
            Header[] actualHeaders = method.getResponseHeaders(headerName);
            JUnit3WebDAVTest.assertTrue((String)("header '" + headerName + "' not found"), (null != actualHeaders && 0 < actualHeaders.length ? 1 : 0) != 0);
            for (Header actualHeader : actualHeaders) {
                HeaderElement[] actualHeaderElements = actualHeader.getElements();
                JUnit3WebDAVTest.assertTrue((String)("no elements found in header '" + headerName + "'"), (null != actualHeaderElements && 0 < actualHeaderElements.length ? 1 : 0) != 0);
                for (HeaderElement actualHeaderElement : actualHeaderElements) {
                    if (!expectedHeader.equals(actualHeaderElement.getName())) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            JUnit3WebDAVTest.assertTrue((String)("header element '" + expectedHeader + "'not found in header '" + headerName + "'"), (boolean)found);
        }
    }
}

