/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.tokenloginV2;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.session.actions.TokenLoginV2Request;
import com.openexchange.ajax.session.actions.TokenLoginV2Response;
import com.openexchange.ajax.tokenloginV2.AcquireTokenRequest;
import com.openexchange.ajax.tokenloginV2.AcquireTokenResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.tokenlogin.TokenLoginExceptionCodes;
import com.openexchange.tools.servlet.AjaxExceptionCodes;

public class TokenLoginV2Test
extends AbstractAJAXSession {
    private static final String SECRET_1 = "1234";
    private static final String SECRET_2 = "4321";

    public TokenLoginV2Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testAcquire() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        TokenLoginV2Test.assertNotNull((String)"Missing token.", (Object)token);
        TokenLoginV2Test.assertFalse((String)"Invalid token.", (boolean)token.equals(""));
        TokenLoginV2Test.assertEquals((String)"Different token.", (String)token, (String)this.getClient().execute(request).getToken());
    }

    public void testLoginWithPassword() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        LoginRequest login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"));
        AJAXClient client = new AJAXClient();
        LoginResponse loginResponse = client.execute(login);
        TokenLoginV2Test.assertEquals((String)"Wrong password.", (String)AJAXConfig.getProperty(AJAXClient.User.User1.getPassword()), (String)loginResponse.getPassword());
        Thread.sleep(500L);
        login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"), false);
        client = new AJAXClient();
        loginResponse = client.execute(login);
        TokenLoginV2Test.assertTrue((String)("Error expected, but got: " + loginResponse.getResponse().toString()), (boolean)loginResponse.hasError());
        int expectedErrorCode = TokenLoginExceptionCodes.NO_SUCH_TOKEN.getNumber();
        int actualErrorCode = loginResponse.getException().getCode();
        TokenLoginV2Test.assertEquals((String)("Wrong error. Expected \"" + expectedErrorCode + "\", but was \"" + actualErrorCode + "\"."), (int)expectedErrorCode, (int)actualErrorCode);
    }

    public void testLoginWithoutPassword() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        LoginRequest login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, SECRET_2, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"));
        AJAXClient client = new AJAXClient();
        LoginResponse loginResponse = client.execute(login);
        TokenLoginV2Test.assertNull((String)"No password expected.", (Object)loginResponse.getPassword());
        login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, SECRET_2, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"), false);
        client = new AJAXClient();
        loginResponse = client.execute(login);
        TokenLoginV2Test.assertTrue((String)"Error expected", (boolean)loginResponse.hasError());
        TokenLoginV2Test.assertEquals((String)"Wrong error.", (int)TokenLoginExceptionCodes.NO_SUCH_TOKEN.getNumber(), (int)loginResponse.getException().getCode());
    }

    public void testBadSecret() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        LoginRequest login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, "blubb", LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"), false);
        AJAXClient client = new AJAXClient();
        LoginResponse loginResponse = client.execute(login);
        TokenLoginV2Test.assertTrue((String)"Error expected.", (boolean)loginResponse.hasError());
        TokenLoginV2Test.assertEquals((String)"Wrong error.", (int)TokenLoginExceptionCodes.TOKEN_REDEEM_DENIED.getNumber(), (int)loginResponse.getException().getCode());
    }

    public void testInvalidate() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        this.getClient().logout();
        LoginRequest login = new LoginRequest(new LoginRequest.TokenLoginParameters(token, SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"), false);
        AJAXClient client = new AJAXClient();
        LoginResponse loginResponse = client.execute(login);
        TokenLoginV2Test.assertTrue((String)"Error expected.", (boolean)loginResponse.hasError());
        TokenLoginV2Test.assertTrue((String)"Wrong error.", (loginResponse.getException().getCode() == TokenLoginExceptionCodes.NO_SUCH_TOKEN.getNumber() || loginResponse.getException().getCode() == TokenLoginExceptionCodes.NO_SUCH_SESSION_FOR_TOKEN.getNumber() ? 1 : 0) != 0);
    }

    public void testBadToken() throws Exception {
        LoginRequest login = new LoginRequest(new LoginRequest.TokenLoginParameters("phantasyToken", SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0"), false);
        AJAXClient client = new AJAXClient();
        LoginResponse loginResponse = client.execute(login);
        TokenLoginV2Test.assertTrue((String)"Error expected.", (boolean)loginResponse.hasError());
    }

    public void testRedirect() throws Exception {
        String REDIRECT = this.client.getHostname() + "/tokenRedirectTest";
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.client.execute(request);
        String token = response.getToken();
        TokenLoginV2Test.assertNotNull((String)"Missing token.", (Object)token);
        TokenLoginV2Test.assertFalse((String)"Invalid token.", (boolean)token.equals(""));
        AJAXClient client2 = new AJAXClient();
        TokenLoginV2Request login = new TokenLoginV2Request(token, SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.8.0", REDIRECT);
        TokenLoginV2Response loginResponse = client2.execute(login);
        TokenLoginV2Test.assertTrue((String)"Tokenlogin failed.", (boolean)loginResponse.isLoginSuccessful());
        TokenLoginV2Test.assertTrue((String)"Redirect urls does not match.", (boolean)loginResponse.getRedirectUrl().startsWith(REDIRECT));
    }

    public void testLoginWithPasswordInURI_doNotAccept() throws Exception {
        AcquireTokenRequest request = new AcquireTokenRequest();
        AcquireTokenResponse response = this.getClient().execute(request);
        String token = response.getToken();
        LoginRequest login = new LoginRequest(token, SECRET_1, LoginTools.generateAuthId(), TokenLoginV2Test.class.getName(), "7.4.0", false, true);
        LoginResponse loginResponse = this.client.execute(login);
        TokenLoginV2Test.assertTrue((String)"Error expected.", (boolean)loginResponse.hasError());
        TokenLoginV2Test.assertEquals((String)"Wrong error.", (int)AjaxExceptionCodes.NOT_ALLOWED_URI_PARAM.getNumber(), (int)loginResponse.getException().getCode());
        TokenLoginV2Test.assertTrue((String)"Wrong param", (boolean)loginResponse.getErrorMessage().contains("password"));
    }
}

