/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import java.util.ArrayList;

public class SharedFilesFolderTest
extends ShareTest {
    private static final String SHARED_FOLDER = "10";
    private FolderObject folder;
    private File file;

    public SharedFilesFolderTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        this.file = this.insertFile(this.folder.getObjectID(), SharedFilesFolderTest.randomUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReShareNotPossibleForInternals() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        AJAXClient client3 = new AJAXClient(AJAXClient.User.User3);
        try {
            ArrayList<DefaultFileStorageObjectPermission> permissions = new ArrayList<DefaultFileStorageObjectPermission>(1);
            permissions.add(new DefaultFileStorageObjectPermission(client2.getValues().getUserId(), false, 2));
            this.file.setObjectPermissions(permissions);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String sharedFileId = SharedFilesFolderTest.sharedFileId(this.file.getId());
            SharedFilesFolderTest.assertFalse((boolean)client2.execute(new GetInfostoreRequest(sharedFileId)).getDocumentMetadata().isShareable());
            DefaultFile toUpdate = new DefaultFile();
            toUpdate.setFolderId(SHARED_FOLDER);
            toUpdate.setId(sharedFileId);
            permissions.add(new DefaultFileStorageObjectPermission(client3.getValues().getUserId(), false, 2));
            toUpdate.setObjectPermissions(permissions);
            UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest((File)toUpdate, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, this.file.getLastModified());
            updateInfostoreRequest.setFailOnError(false);
            UpdateInfostoreResponse updateInfostoreResponse = client2.execute(updateInfostoreRequest);
            SharedFilesFolderTest.assertTrue((boolean)updateInfostoreResponse.hasError());
            SharedFilesFolderTest.assertTrue((boolean)InfostoreExceptionCodes.NO_WRITE_PERMISSION.equals(updateInfostoreResponse.getException()));
        }
        finally {
            client2.logout();
            client3.logout();
        }
    }

    public void testReShareNotPossibleForInvitedGuests() throws Exception {
        ArrayList<FileStorageGuestObjectPermission> permissions = new ArrayList<FileStorageGuestObjectPermission>(1);
        String guestEmail = SharedFilesFolderTest.randomUID() + "@example.com";
        OCLGuestPermission guestPermission = SharedFilesFolderTest.createNamedAuthorPermission(guestEmail, SharedFilesFolderTest.randomUID());
        permissions.add(SharedFilesFolderTest.asObjectPermission(guestPermission));
        this.file.setObjectPermissions(permissions);
        this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
        String sharedFileId = SharedFilesFolderTest.sharedFileId(this.file.getId());
        String invitationLink = this.discoverInvitationLink(this.client, guestEmail);
        GuestClient guestClient = this.resolveShare(invitationLink);
        guestPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkFileAccessible(sharedFileId, guestPermission);
        SharedFilesFolderTest.assertFalse((boolean)guestClient.execute(new GetInfostoreRequest(sharedFileId)).getDocumentMetadata().isShareable());
        DefaultFile toUpdate = new DefaultFile();
        toUpdate.setFolderId(SHARED_FOLDER);
        toUpdate.setId(sharedFileId);
        permissions.add(SharedFilesFolderTest.asObjectPermission(SharedFilesFolderTest.createNamedAuthorPermission(SharedFilesFolderTest.randomUID() + "example.com", SharedFilesFolderTest.randomUID())));
        toUpdate.setObjectPermissions(permissions);
        UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest((File)toUpdate, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, this.file.getLastModified());
        updateInfostoreRequest.setFailOnError(false);
        UpdateInfostoreResponse updateInfostoreResponse = guestClient.execute(updateInfostoreRequest);
        SharedFilesFolderTest.assertTrue((boolean)updateInfostoreResponse.hasError());
        SharedFilesFolderTest.assertTrue((boolean)InfostoreExceptionCodes.NO_WRITE_PERMISSION.equals(updateInfostoreResponse.getException()));
    }

    private static String sharedFileId(String fileId) {
        FileID tmp = new FileID(fileId);
        tmp.setFolderId(SHARED_FOLDER);
        return tmp.toUniqueID();
    }
}

