/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.VersionsRequest;
import com.openexchange.ajax.folder.actions.VersionsResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.CopyInfostoreRequest;
import com.openexchange.ajax.infostore.actions.CopyInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.tests.AbstractSharedFilesTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import org.json.JSONException;

public class CopySharedFilesVersionsRemovalTest
extends AbstractSharedFilesTest {
    public CopySharedFilesVersionsRemovalTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_ownerCopiesFile_fileBecomesCopiedWithoutVersions() throws Exception {
        this.userDestFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID());
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        try {
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            this.createNewFileVersions();
            this.assertExistingVersions(this.file.getId(), 5);
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            String newObjectId = this.infoMgr.copyAction(this.file.getId(), Integer.toString(this.userDestFolder.getObjectID()), this.file);
            com.openexchange.file.storage.File copiedFile = this.client.execute(new GetInfostoreRequest(newObjectId)).getDocumentMetadata();
            this.assertExistingVersions(copiedFile.getId(), 1);
        }
        finally {
            client2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_ownerCopiesFileWithDefinedVersion_fileBecomesCopiedWithoutVersions() throws Exception {
        this.userDestFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID());
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        try {
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            this.createNewFileVersions();
            this.assertExistingVersions(this.file.getId(), 5);
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(this.file.getId(), Integer.toString(this.userDestFolder.getObjectID()), this.file, "2");
            CopyInfostoreResponse copyResponse = this.client.execute(copyRequest);
            String newObjectId = copyResponse.getID();
            com.openexchange.file.storage.File copiedFile = this.client.execute(new GetInfostoreRequest(newObjectId)).getDocumentMetadata();
            this.assertExistingVersions(copiedFile.getId(), 1);
        }
        finally {
            client2.logout();
        }
    }

    private void assertExistingVersions(String id, int expectedVersions) throws OXException, IOException, JSONException {
        File.Field[] fields = new File.Field[]{File.Field.NUMBER_OF_VERSIONS, File.Field.VERSION, File.Field.CURRENT_VERSION, File.Field.CREATED_BY};
        VersionsResponse versions = this.client.execute(new VersionsRequest(id, fields));
        CopySharedFilesVersionsRemovalTest.assertEquals((String)"Wrong number of versions", (int)expectedVersions, (int)versions.getVersions().size());
    }

    private void createNewFileVersions() throws OXException, IOException, JSONException, InterruptedException {
        this.createNewFileVersions(this.client, this.file);
    }

    private void createNewFileVersions(AJAXClient theClient, com.openexchange.file.storage.File theFile) throws OXException, IOException, JSONException, InterruptedException {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest(theFile, new File.Field[]{File.Field.NUMBER_OF_VERSIONS, File.Field.VERSION, File.Field.CURRENT_VERSION, File.Field.CREATED_BY, File.Field.CONTENT}, upload, theFile.getLastModified());
        for (int i = 0; i < 4; ++i) {
            theClient.execute(updateInfostoreRequest);
            Thread.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_guestCopiesFile_fileBecomesCopiedWithoutVersions() throws Exception {
        OCLGuestPermission lGuestPermission = CopySharedFilesVersionsRemovalTest.createNamedAuthorPermission(CopySharedFilesVersionsRemovalTest.randomUID() + "@example.com", "Test Guest", "secret");
        this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID(), lGuestPermission);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        AJAXClient guestClient = null;
        try {
            this.addUserPermission(client2.getValues().getUserId());
            this.addGuestPermission(lGuestPermission.getRecipient());
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            this.createNewFileVersions();
            this.assertExistingVersions(this.file.getId(), 5);
            String sharedFileId = CopySharedFilesVersionsRemovalTest.sharedFileId(this.file.getId());
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            OCLPermission matchingPermission = null;
            for (OCLPermission permission : this.userDestFolder.getPermissions()) {
                if (permission.getEntity() == this.client.getValues().getUserId()) continue;
                matchingPermission = permission;
                break;
            }
            ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.userDestFolder.getObjectID(), matchingPermission.getEntity());
            CopySharedFilesVersionsRemovalTest.checkGuestPermission(lGuestPermission, guest);
            String shareURL = this.discoverShareURL(guest);
            guestClient = this.resolveShare(shareURL, CopySharedFilesVersionsRemovalTest.getUsername(lGuestPermission.getRecipient()), CopySharedFilesVersionsRemovalTest.getPassword(lGuestPermission.getRecipient()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = guestClient.execute(copyRequest);
            com.openexchange.file.storage.File copiedFile = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            this.assertExistingVersions(copiedFile.getId(), 1);
        }
        finally {
            client2.logout();
            if (guestClient != null) {
                guestClient.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_guestCreatesNewVersionAndCopiesFile_fileBecomesCopiedWithoutVersions() throws Exception {
        OCLGuestPermission lGuestPermission = CopySharedFilesVersionsRemovalTest.createNamedAuthorPermission(CopySharedFilesVersionsRemovalTest.randomUID() + "@example.com", "Test Guest", "secret");
        this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID(), lGuestPermission);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        AJAXClient guestClient = null;
        try {
            this.addUserPermission(client2.getValues().getUserId());
            this.addGuestPermission(lGuestPermission.getRecipient());
            this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            this.createNewFileVersions();
            this.assertExistingVersions(this.file.getId(), 5);
            String sharedFileId = CopySharedFilesVersionsRemovalTest.sharedFileId(this.file.getId());
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            OCLPermission matchingPermission = null;
            for (OCLPermission permission : this.userDestFolder.getPermissions()) {
                if (permission.getEntity() == this.client.getValues().getUserId()) continue;
                matchingPermission = permission;
                break;
            }
            ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.userDestFolder.getObjectID(), matchingPermission.getEntity());
            CopySharedFilesVersionsRemovalTest.checkGuestPermission(lGuestPermission, guest);
            String shareURL = this.discoverShareURL(guest);
            guestClient = this.resolveShare(shareURL, CopySharedFilesVersionsRemovalTest.getUsername(lGuestPermission.getRecipient()), CopySharedFilesVersionsRemovalTest.getPassword(lGuestPermission.getRecipient()));
            com.openexchange.file.storage.File sharedFileToCopy = guestClient.execute(new GetInfostoreRequest(sharedFileId)).getDocumentMetadata();
            this.createNewFileVersions(guestClient, sharedFileToCopy);
            this.assertExistingVersions(this.file.getId(), 9);
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = guestClient.execute(copyRequest);
            com.openexchange.file.storage.File copiedFile1 = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            this.assertExistingVersions(copiedFile1.getId(), 1);
        }
        finally {
            client2.logout();
            if (guestClient != null) {
                guestClient.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_internalUserCopiesFile_fileBecomesCopiedWithoutVersions() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        try {
            OCLPermission permission = new OCLPermission(userId, 0);
            permission.setAllPermission(128, 128, 128, 128);
            this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID(), permission);
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String sharedFileId = CopySharedFilesVersionsRemovalTest.sharedFileId(this.file.getId());
            this.createNewFileVersions();
            this.assertExistingVersions(this.file.getId(), 5);
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = client2.execute(copyRequest);
            com.openexchange.file.storage.File copiedFile = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            this.assertExistingVersions(copiedFile.getId(), 1);
        }
        finally {
            client2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_internalUserCreatesNewVersionsAndCopiesFile_fileBecomesCopiedWithoutVersions() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        try {
            OCLPermission permission = new OCLPermission(userId, 0);
            permission.setAllPermission(4, 4, 4, 4);
            this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesVersionsRemovalTest.randomUID(), permission);
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String sharedFileId = CopySharedFilesVersionsRemovalTest.sharedFileId(this.file.getId());
            this.createNewFileVersions();
            com.openexchange.file.storage.File copiedFile = client2.execute(new GetInfostoreRequest(sharedFileId)).getDocumentMetadata();
            this.createNewFileVersions(client2, copiedFile);
            this.assertExistingVersions(this.file.getId(), 9);
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = client2.execute(copyRequest);
            com.openexchange.file.storage.File copiedFile1 = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            this.assertExistingVersions(copiedFile1.getId(), 1);
        }
        finally {
            client2.logout();
        }
    }
}

