/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.CopyInfostoreRequest;
import com.openexchange.ajax.infostore.actions.CopyInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.tests.AbstractSharedFilesTest;
import com.openexchange.file.storage.File;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.ShareRecipient;

public class CopySharedFilesPermissionRemovalTest
extends AbstractSharedFilesTest {
    public CopySharedFilesPermissionRemovalTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_ownerCopiesFile_fileBecomesCopiedWithoutObjectPermissions() throws Exception {
        this.userDestFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesPermissionRemovalTest.randomUID());
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        try {
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            File documentMetadata = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of shares users/guests", (int)2, (int)documentMetadata.getObjectPermissions().size());
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            String newObjectId = this.infoMgr.copyAction(this.file.getId(), Integer.toString(this.userDestFolder.getObjectID()), this.file);
            File copiedFile = this.client.execute(new GetInfostoreRequest(newObjectId)).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Object permissions should not be available!", (int)0, (int)copiedFile.getObjectPermissions().size());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"File not created by main user", (int)this.client.getValues().getUserId(), (int)copiedFile.getCreatedBy());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of versions", (int)1, (int)copiedFile.getNumberOfVersions());
        }
        finally {
            client2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_guestCopiesFile_fileBecomesCopiedWithoutObjectPermissions() throws Exception {
        OCLGuestPermission lGuestPermission = CopySharedFilesPermissionRemovalTest.createNamedAuthorPermission(CopySharedFilesPermissionRemovalTest.randomUID() + "@example.com", "Test Guest", "secret");
        this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesPermissionRemovalTest.randomUID(), lGuestPermission);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        AJAXClient guestClient = null;
        try {
            this.addUserPermission(client2.getValues().getUserId());
            this.addGuestPermission(lGuestPermission.getRecipient());
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String sharedFileId = CopySharedFilesPermissionRemovalTest.sharedFileId(this.file.getId());
            File documentMetadata = this.client.execute(new GetInfostoreRequest(sharedFileId)).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of shares users/guests", (int)2, (int)documentMetadata.getObjectPermissions().size());
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            OCLPermission matchingPermission = null;
            for (OCLPermission permission : this.userDestFolder.getPermissions()) {
                if (permission.getEntity() == this.client.getValues().getUserId()) continue;
                matchingPermission = permission;
                break;
            }
            ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.userDestFolder.getObjectID(), matchingPermission.getEntity());
            CopySharedFilesPermissionRemovalTest.checkGuestPermission(lGuestPermission, guest);
            String shareURL = this.discoverShareURL(guest);
            guestClient = this.resolveShare(shareURL, CopySharedFilesPermissionRemovalTest.getUsername(lGuestPermission.getRecipient()), CopySharedFilesPermissionRemovalTest.getPassword(lGuestPermission.getRecipient()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = guestClient.execute(copyRequest);
            CopySharedFilesPermissionRemovalTest.assertNull((String)"No conflict should occur!", copyResponse.getConflicts());
            CopySharedFilesPermissionRemovalTest.assertNull((String)"No error should occur!", (Object)copyResponse.getErrorMessage());
            CopySharedFilesPermissionRemovalTest.assertNull((String)"No exception should occur!", (Object)((Object)copyResponse.getException()));
            File copiedFile = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Object permissions should not be available!", (int)0, (int)copiedFile.getObjectPermissions().size());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"File not created by guest", (int)guestClient.getValues().getUserId(), (int)copiedFile.getCreatedBy());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of versions", (int)1, (int)copiedFile.getNumberOfVersions());
        }
        finally {
            client2.logout();
            if (guestClient != null) {
                guestClient.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopySharedFile_internalUserCopiesFile_fileBecomesCopiedWithoutObjectPermissions() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        try {
            OCLPermission permission = new OCLPermission(userId, 0);
            permission.setAllPermission(128, 128, 128, 128);
            this.userDestFolder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder(), "dest_" + CopySharedFilesPermissionRemovalTest.randomUID(), permission);
            this.addUserPermission(client2.getValues().getUserId());
            GuestRecipient recipient = new GuestRecipient();
            recipient.setEmailAddress("test@invalid.invalid");
            this.addGuestPermission((ShareRecipient)recipient);
            this.file = this.updateFile(this.file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
            String sharedFileId = CopySharedFilesPermissionRemovalTest.sharedFileId(this.file.getId());
            File documentMetadata = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of shares users/guests", (int)2, (int)documentMetadata.getObjectPermissions().size());
            this.file.setFolderId(Integer.toString(this.userDestFolder.getObjectID()));
            CopyInfostoreRequest copyRequest = new CopyInfostoreRequest(sharedFileId, "10", this.file);
            copyRequest.setFailOnError(true);
            CopyInfostoreResponse copyResponse = client2.execute(copyRequest);
            File copiedFile = this.client.execute(new GetInfostoreRequest(copyResponse.getID())).getDocumentMetadata();
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Object permissions should not be available!", (int)0, (int)copiedFile.getObjectPermissions().size());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"File not created by internal user", (int)userId, (int)copiedFile.getCreatedBy());
            CopySharedFilesPermissionRemovalTest.assertEquals((String)"Wrong number of versions", (int)1, (int)copiedFile.getNumberOfVersions());
        }
        finally {
            client2.logout();
        }
    }
}

