/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.session.actions.LoginResponseParser;
import com.openexchange.java.Strings;
import java.util.ArrayList;

public class LoginRequest
extends AbstractRequest<LoginResponse> {
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_TOKEN = "token";
    private static final String PARAM_SECRET = "secret";
    private static final String PARAM_LANGUAGE = "language";
    private final boolean failOnError;

    public static LoginRequest createGuestLoginRequest(String share, String target, GuestCredentials credentials, String client, boolean failOnError) {
        ArrayList<AJAXRequest.Parameter> parameters = new ArrayList<AJAXRequest.Parameter>();
        parameters.add(new AJAXRequest.URLParameter("action", "guest"));
        parameters.add(new AJAXRequest.URLParameter("share", share));
        if (null != target) {
            parameters.add(new AJAXRequest.URLParameter("target", target));
        }
        if (null != client && !client.isEmpty()) {
            parameters.add(new AJAXRequest.URLParameter("client", client));
        }
        parameters.add(new AJAXRequest.FieldParameter(PARAM_NAME, credentials.login));
        if (Strings.isEmpty((String)credentials.password)) {
            parameters.add(new AJAXRequest.FieldParameter(PARAM_PASSWORD, ""));
        } else {
            parameters.add(new AJAXRequest.FieldParameter(PARAM_PASSWORD, credentials.password));
        }
        return new LoginRequest(parameters.toArray(new AJAXRequest.Parameter[parameters.size()]), failOnError);
    }

    public static LoginRequest createGuestLoginRequest(String share, String target, GuestCredentials credentials, boolean failOnError) {
        return LoginRequest.createGuestLoginRequest(share, target, credentials, null, failOnError);
    }

    public static LoginRequest createAnonymousLoginRequest(String share, String target, String password, boolean failOnError) {
        ArrayList<AJAXRequest.Parameter> parameters = new ArrayList<AJAXRequest.Parameter>();
        parameters.add(new AJAXRequest.URLParameter("action", "anonymous"));
        parameters.add(new AJAXRequest.URLParameter("share", share));
        if (null != target) {
            parameters.add(new AJAXRequest.URLParameter("target", target));
        }
        parameters.add(new AJAXRequest.FieldParameter(PARAM_PASSWORD, password));
        return new LoginRequest(parameters.toArray(new AJAXRequest.Parameter[parameters.size()]), failOnError);
    }

    public LoginRequest(TokenLoginParameters parameters, boolean failOnError) {
        this(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "redeemToken"), new AJAXRequest.URLParameter("authId", parameters.getAuthId()), new AJAXRequest.URLParameter("client", parameters.getClient()), new AJAXRequest.URLParameter("version", parameters.getVersion()), new AJAXRequest.FieldParameter(PARAM_TOKEN, parameters.getToken()), new AJAXRequest.FieldParameter(PARAM_SECRET, parameters.getSecret())}, failOnError);
    }

    public LoginRequest(TokenLoginParameters parameters) {
        this(parameters, true);
    }

    public LoginRequest(String login, String password, String authId, String client, String version) {
        this(login, password, authId, client, version, true);
    }

    public LoginRequest(String login, String password, String authId, String client, String version, boolean failOnError) {
        this(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "login"), new AJAXRequest.URLParameter("authId", authId), new AJAXRequest.URLParameter("client", client), new AJAXRequest.URLParameter("version", version), new AJAXRequest.FieldParameter(PARAM_NAME, login), new AJAXRequest.FieldParameter(PARAM_PASSWORD, password)}, failOnError);
    }

    public LoginRequest(String login, String password, String authId, String client, String version, boolean failOnError, boolean passwordInURL) {
        this(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "login"), new AJAXRequest.URLParameter("authId", authId), new AJAXRequest.URLParameter("client", client), new AJAXRequest.URLParameter("version", version), new AJAXRequest.URLParameter(PARAM_PASSWORD, password), new AJAXRequest.FieldParameter(PARAM_NAME, login), new AJAXRequest.FieldParameter(PARAM_PASSWORD, password)}, failOnError);
    }

    public LoginRequest(String login, String password, String authId, String client, String version, String language, boolean failOnError) {
        this(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "login"), new AJAXRequest.URLParameter("authId", authId), new AJAXRequest.URLParameter("client", client), new AJAXRequest.URLParameter("version", version), new AJAXRequest.FieldParameter(PARAM_NAME, login), new AJAXRequest.FieldParameter(PARAM_PASSWORD, password), new AJAXRequest.FieldParameter(PARAM_LANGUAGE, language)}, failOnError);
    }

    public LoginRequest(String login, String password, String authId, String client, String version, String language, boolean storeLanguage, boolean failOnError) {
        this(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "login"), new AJAXRequest.URLParameter("authId", authId), new AJAXRequest.URLParameter("client", client), new AJAXRequest.URLParameter("version", version), new AJAXRequest.FieldParameter(PARAM_NAME, login), new AJAXRequest.FieldParameter(PARAM_PASSWORD, password), new AJAXRequest.FieldParameter(PARAM_LANGUAGE, language), new AJAXRequest.FieldParameter("storeLanguage", String.valueOf(storeLanguage))}, failOnError);
    }

    protected LoginRequest(AJAXRequest.Parameter[] parameters, boolean failOnError) {
        super(parameters);
        this.failOnError = failOnError;
    }

    public LoginResponseParser getParser() {
        return new LoginResponseParser(this.failOnError);
    }

    public static class TokenLoginParameters {
        String token;
        String secret;
        String authId;
        String client;
        String version;

        public TokenLoginParameters(String token, String secret, String authId, String client, String version) {
            this.token = token;
            this.secret = secret;
            this.authId = authId;
            this.client = client;
            this.version = version;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getAuthId() {
            return this.authId;
        }

        public void setAuthId(String authId) {
            this.authId = authId;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static final class GuestCredentials {
        private final String login;
        private final String password;

        public GuestCredentials(String login) {
            this.login = login;
            this.password = null;
        }

        public GuestCredentials(String login, String password) {
            this.login = login;
            this.password = password;
        }
    }
}

