/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.session.actions.RedirectRequest;
import com.openexchange.ajax.session.actions.RedirectResponse;
import com.openexchange.ajax.session.actions.StoreRequest;
import com.openexchange.config.internal.ConfigurationImpl;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.groupware.Init;
import com.openexchange.java.Strings;
import com.openexchange.login.ConfigurationProperty;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.cookie.Cookie;

public class RedirectTest
extends AbstractAJAXSession {
    private String login;
    private String password;
    private boolean insecure;

    public RedirectTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        Init.injectProperty();
        ConfigurationImpl configService = new ConfigurationImpl(Collections.emptyList());
        String value = configService.getProperty(ConfigurationProperty.INSECURE.getPropertyName(), ConfigurationProperty.INSECURE.getDefaultValue());
        this.insecure = Boolean.parseBoolean(value);
    }

    @Override
    protected void tearDown() throws Exception {
        this.login = null;
        this.password = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirect() throws Throwable {
        AJAXSession session = new AJAXSession();
        AJAXClient myClient = new AJAXClient(session, false);
        try {
            LoginResponse lResponse = myClient.execute(new LoginRequest(this.login, this.password, LoginTools.generateAuthId(), RedirectTest.class.getName(), "6.19.0"));
            if (Strings.isEmpty((String)lResponse.getRandom())) {
                return;
            }
            myClient.execute(new StoreRequest(lResponse.getSessionId(), false));
            ArrayList<String> cookieList = new ArrayList<String>();
            for (Cookie cookie : session.getHttpClient().getCookieStore().getCookies()) {
                if ("JSESSIONID".equals(cookie.getName())) continue;
                cookieList.add(cookie.getName());
            }
            session.getHttpClient().getCookieStore().clear();
            session.getHttpClient().getParams().setBooleanParameter("http.protocol.handle-redirects", false);
            String clientIdentifier = this.insecure ? RedirectTest.class.getName() + '2' : RedirectTest.class.getName();
            RedirectRequest request = new RedirectRequest(lResponse.getJvmRoute(), lResponse.getRandom(), clientIdentifier);
            RedirectResponse rResponse = myClient.execute(request);
            RedirectTest.assertNotNull((String)"Redirect location is missing.", (Object)rResponse.getLocation());
            for (Cookie cookie : session.getHttpClient().getCookieStore().getCookies()) {
                String name = cookie.getName();
                if (!this.insecure) continue;
                RedirectTest.assertFalse((String)("Cookie " + name + " was not removed after redirect."), (boolean)cookieList.contains(name));
            }
            session.setId(lResponse.getSessionId());
        }
        finally {
            myClient.logout();
        }
    }
}

