/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.configuration.MailConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FileResponseRendererTools {
    public static ByteArrayFileHolder getFileHolder(String filename) throws IOException {
        return FileResponseRendererTools.getFileHolder(FileResponseRendererTools.readFile(filename), filename);
    }

    public static ByteArrayFileHolder getFileHolder(String filename, String contentType, Delivery delivery, Disposition disposition, String fname) throws IOException {
        return FileResponseRendererTools.getFileHolder(FileResponseRendererTools.readFile(filename), contentType, delivery, disposition, fname);
    }

    public static ByteArrayFileHolder getFileHolder(byte[] bytes, String contentType, Delivery delivery, Disposition disposition, String filename) {
        ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(bytes);
        fileHolder.setContentType(contentType);
        fileHolder.setDelivery(delivery.toString());
        fileHolder.setDisposition(disposition.toString());
        fileHolder.setName(filename);
        return fileHolder;
    }

    public static ByteArrayFileHolder getFileHolder(byte[] bytes, String filename) {
        ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(bytes);
        fileHolder.setName(filename);
        return fileHolder;
    }

    public static byte[] newByteArray(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    private static byte[] readFile(String filename) throws IOException {
        String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        File file = new File(testDataDir, filename);
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        return bytes;
    }

    public static enum Disposition {
        attachment,
        inline;

    }

    public static enum Delivery {
        view,
        download;

    }
}

