/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.openexchange.ajax.onboarding.actions.ExecuteRequest;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import com.openexchange.ajax.onboarding.tests.AbstractPlistSMSTest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PlistSMSUserLimitTest
extends AbstractPlistSMSTest {
    public PlistSMSUserLimitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Thread.sleep(61000L);
    }

    public void testExceedUserLimitTest() throws Exception {
        String jsonString = "{\"sms\":\"+49276183850\"}";
        JSONObject body = new JSONObject(jsonString);
        for (int x = 0; x < 3; ++x) {
            ExecuteRequest req = new ExecuteRequest("apple.iphone/mailsync", "sms", body, false);
            OnboardingTestResponse response = this.client.execute(req);
            PlistSMSUserLimitTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
            PlistSMSUserLimitTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
            if (x < 2) {
                PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)3, (int)response.getException().getCode());
                PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"SMS", (String)response.getException().getPrefix());
                continue;
            }
            PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)1, (int)response.getException().getCode());
            PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"SMSLIMIT", (String)response.getException().getPrefix());
        }
    }

    public void testRefreshTest() throws Exception {
        String jsonString = "{\"sms\":\"+49276183850\"}";
        JSONObject body = new JSONObject(jsonString);
        for (int x = 0; x < 10; ++x) {
            ExecuteRequest req = new ExecuteRequest("apple.iphone/mailsync", "sms", body, false);
            OnboardingTestResponse response = this.client.execute(req);
            PlistSMSUserLimitTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
            PlistSMSUserLimitTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
            if (response.getException().getCode() == 1 && response.getException().getPrefix().equals("SMSLIMIT")) break;
            if (x != 9) continue;
            PlistSMSUserLimitTest.fail((String)"User sms limit is never reached!");
        }
        Thread.sleep(61000L);
        ExecuteRequest req = new ExecuteRequest("apple.iphone/mailsync", "sms", body, false);
        OnboardingTestResponse response = this.client.execute(req);
        PlistSMSUserLimitTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        PlistSMSUserLimitTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
        PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)3, (int)response.getException().getCode());
        PlistSMSUserLimitTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"SMS", (String)response.getException().getPrefix());
    }

    @Override
    protected Map<String, String> getNeededConfigurations() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.openexchange.sms.userlimit", String.valueOf(2));
        map.put("com.openexchange.sms.userlimit.refreshInterval", String.valueOf(1));
        return map;
    }
}

