/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.oauth.provider.authorizationserver.client.Client;
import com.openexchange.oauth.provider.authorizationserver.client.DefaultClient;
import com.openexchange.oauth.provider.authorizationserver.grant.DefaultGrantView;
import com.openexchange.oauth.provider.authorizationserver.grant.GrantView;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AllResponse
extends AbstractAJAXResponse {
    protected AllResponse(Response response) {
        super(response);
    }

    public List<GrantView> getGrantViews() throws JSONException {
        LinkedList<GrantView> grants = new LinkedList<GrantView>();
        JSONArray data = (JSONArray)this.getData();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject jGrant = data.getJSONObject(i);
            JSONObject jClient = jGrant.getJSONObject("client");
            DefaultClient client = new DefaultClient();
            client.setId(jClient.getString("id"));
            client.setName(jClient.getString("name"));
            client.setDescription(jClient.getString("description"));
            client.setWebsite(jClient.getString("website"));
            LinkedList scopeTokens = new LinkedList();
            JSONObject jScopes = jGrant.getJSONObject("scopes");
            scopeTokens.addAll(jScopes.keySet());
            Scope scope = Scope.newInstance(scopeTokens);
            Date latestGrantDate = new Date(jGrant.getLong("date"));
            DefaultGrantView grant = new DefaultGrantView();
            grant.setClient((Client)client);
            grant.setScope(scope);
            grant.setLatestGrantDate(latestGrantDate);
            grants.add((GrantView)grant);
        }
        return grants;
    }
}

