/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.IconBytes;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.Strings;
import com.openexchange.oauth.provider.authorizationserver.client.ClientManagementException;
import com.openexchange.oauth.provider.impl.tools.ClientId;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import com.openexchange.oauth.provider.rmi.client.ClientDataDto;
import com.openexchange.oauth.provider.rmi.client.ClientDto;
import com.openexchange.oauth.provider.rmi.client.IconDto;
import com.openexchange.oauth.provider.rmi.client.RemoteClientManagement;
import com.openexchange.oauth.provider.rmi.client.RemoteClientManagementException;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ClientManagementTest {
    private RemoteClientManagement clientManagement;
    private Credentials credentials;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void initTestFramework() throws Exception {
        AJAXConfig.init();
    }

    @Before
    public void before() throws Exception {
        this.clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        this.credentials = AbstractOAuthTest.getMasterAdminCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientLifecycle() throws Exception {
        ClientDto reloaded;
        boolean found;
        List clients;
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        ClientDto client = this.clientManagement.registerClient("default", clientData, this.credentials);
        String groupId = ClientId.parse((String)client.getId()).getGroupId();
        try {
            ClientManagementTest.compare(clientData, client);
            clients = this.clientManagement.getClients(groupId, this.credentials);
            found = false;
            for (ClientDto c : clients) {
                if (!client.getId().equals(c.getId())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
            reloaded = this.clientManagement.getClientById(client.getId(), this.credentials);
            ClientManagementTest.compare(client, reloaded);
            Assert.assertTrue((boolean)this.clientManagement.disableClient(client.getId(), this.credentials));
            reloaded = this.clientManagement.getClientById(client.getId(), this.credentials);
            Assert.assertFalse((boolean)reloaded.isEnabled());
            Assert.assertFalse((boolean)this.clientManagement.disableClient(client.getId(), this.credentials));
            Assert.assertTrue((boolean)this.clientManagement.enableClient(client.getId(), this.credentials));
            reloaded = this.clientManagement.getClientById(client.getId(), this.credentials);
            Assert.assertTrue((boolean)reloaded.isEnabled());
            Assert.assertFalse((boolean)this.clientManagement.enableClient(client.getId(), this.credentials));
            String oldSecret = client.getSecret();
            client = this.clientManagement.revokeClientSecret(client.getId(), this.credentials);
            Assert.assertNotNull((Object)client.getSecret());
            Assert.assertNotEquals((Object)oldSecret, (Object)client.getSecret());
            ClientDataDto updatedClientData = new ClientDataDto();
            updatedClientData.setName(Strings.reverse((String)client.getName()));
            updatedClientData.setContactAddress(Strings.reverse((String)client.getContactAddress()));
            updatedClientData.setDescription(Strings.reverse((String)client.getDescription()));
            updatedClientData.setWebsite(Strings.reverse((String)client.getWebsite()));
            IconDto updatedIcon = new IconDto();
            updatedIcon.setMimeType("image/png");
            byte[] originalIconBytes = client.getIcon().getData();
            byte[] updatedIconBytes = new byte[originalIconBytes.length];
            System.arraycopy(originalIconBytes, 0, updatedIconBytes, 0, originalIconBytes.length);
            Arrays.sort(updatedIconBytes);
            updatedIcon.setData(updatedIconBytes);
            updatedClientData.setIcon(updatedIcon);
            updatedClientData.setRedirectURIs(Collections.singletonList("https://example.com/oauth/client/endpoint"));
            updatedClientData.setDefaultScope(Scope.newInstance((String[])new String[]{"read_contacts", "write_contacts"}).toString());
            client = this.clientManagement.updateClient(client.getId(), updatedClientData, this.credentials);
            ClientManagementTest.compare(updatedClientData, client);
        }
        finally {
            Assert.assertTrue((boolean)this.clientManagement.unregisterClient(client.getId(), this.credentials));
            clients = this.clientManagement.getClients(groupId, this.credentials);
            found = false;
            for (ClientDto c : clients) {
                if (!client.getId().equals(c.getId())) continue;
                found = true;
                break;
            }
            Assert.assertFalse((boolean)found);
            reloaded = this.clientManagement.getClientById(client.getId(), this.credentials);
            Assert.assertNull((Object)reloaded);
        }
    }

    @Test
    public void testUpdatePermutations() throws Exception {
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        ClientDto client = this.clientManagement.registerClient("default", clientData, this.credentials);
        ClientManagementTest.compare(clientData, client);
        clientData = new ClientDataDto();
        clientData.setName(Strings.reverse((String)client.getName()));
        Assert.assertTrue((boolean)clientData.containsName());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getName(), (Object)client.getName());
        clientData = new ClientDataDto();
        clientData.setDescription(Strings.reverse((String)client.getDescription()));
        Assert.assertTrue((boolean)clientData.containsDescription());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getDescription(), (Object)client.getDescription());
        clientData = new ClientDataDto();
        clientData.setWebsite(Strings.reverse((String)client.getWebsite()));
        Assert.assertTrue((boolean)clientData.containsWebsite());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getWebsite(), (Object)client.getWebsite());
        clientData = new ClientDataDto();
        clientData.setContactAddress(Strings.reverse((String)client.getContactAddress()));
        Assert.assertTrue((boolean)clientData.containsContactAddress());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getContactAddress(), (Object)client.getContactAddress());
        clientData = new ClientDataDto();
        clientData.setDefaultScope("read_tasks write_tasks");
        Assert.assertTrue((boolean)clientData.containsDefaultScope());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getDefaultScope(), (Object)client.getDefaultScope());
        clientData = new ClientDataDto();
        clientData.setRedirectURIs(Collections.singletonList("http://[::1]/some/where"));
        Assert.assertTrue((boolean)clientData.containsRedirectURIs());
        client = this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
        Assert.assertEquals((Object)clientData.getRedirectURIs(), (Object)client.getRedirectURIs());
    }

    @Test
    public void testInvalidRedirectURIOnRegister() throws Exception {
        String invalidURI = "http://oauth.example.com/api/callback";
        this.thrown.expect((Matcher)new CMEMatcher(invalidURI));
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        clientData.setRedirectURIs(Collections.singletonList(invalidURI));
        this.clientManagement.registerClient("default", clientData, this.credentials);
    }

    @Test
    public void testInvalidRedirectURIOnUpdate() throws Exception {
        ClientDto client = this.clientManagement.registerClient("default", ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis()), this.credentials);
        String invalidURI = "http://oauth.example.com/api/callback";
        this.thrown.expect((Matcher)new CMEMatcher(invalidURI));
        ClientDataDto clientData = new ClientDataDto();
        clientData.setRedirectURIs(Collections.singletonList(invalidURI));
        this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
    }

    @Test
    public void testInvalidIconMimeTypeOnRegister() throws Exception {
        String invalidMimeType = "image/gif";
        this.thrown.expect((Matcher)new CMEMatcher(invalidMimeType));
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        IconDto icon = new IconDto();
        icon.setData(IconBytes.DATA);
        icon.setMimeType(invalidMimeType);
        clientData.setIcon(icon);
        this.clientManagement.registerClient("default", clientData, this.credentials);
    }

    @Test
    public void testInvalidIconMimeTypeOnUpdate() throws Exception {
        ClientDto client = this.clientManagement.registerClient("default", ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis()), this.credentials);
        String invalidMimeType = "image/gif";
        this.thrown.expect((Matcher)new CMEMatcher(invalidMimeType));
        ClientDataDto clientData = new ClientDataDto();
        IconDto icon = new IconDto();
        icon.setData(IconBytes.DATA);
        icon.setMimeType(invalidMimeType);
        clientData.setIcon(icon);
        this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
    }

    @Test
    public void testIconTooLargeOnRegister() throws Exception {
        int maxSize = 262144;
        this.thrown.expect((Matcher)new CMEMatcher(Integer.toString(maxSize)));
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        IconDto icon = new IconDto();
        byte[] data = new byte[maxSize + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        icon.setData(data);
        icon.setMimeType("image/png");
        clientData.setIcon(icon);
        this.clientManagement.registerClient("default", clientData, this.credentials);
    }

    @Test
    public void testIconTooLargeOnUpdate() throws Exception {
        ClientDto client = this.clientManagement.registerClient("default", ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis()), this.credentials);
        int maxSize = 262144;
        this.thrown.expect((Matcher)new CMEMatcher(Integer.toString(maxSize)));
        ClientDataDto clientData = new ClientDataDto();
        IconDto icon = new IconDto();
        byte[] data = new byte[maxSize + 1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        icon.setData(data);
        icon.setMimeType("image/png");
        clientData.setIcon(icon);
        this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
    }

    @Test
    public void testInvalidScopeOnRegister() throws Exception {
        String invalidScope = "doSomething";
        this.thrown.expect((Matcher)new CMEMatcher(invalidScope));
        ClientDataDto clientData = ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis());
        clientData.setDefaultScope(invalidScope);
        this.clientManagement.registerClient("default", clientData, this.credentials);
    }

    @Test
    public void testInvalidScopeOnUpdate() throws Exception {
        ClientDto client = this.clientManagement.registerClient("default", ClientManagementTest.prepareClient(ClientManagementTest.class.getSimpleName() + "_" + System.currentTimeMillis()), this.credentials);
        String invalidScope = "doSomething";
        this.thrown.expect((Matcher)new CMEMatcher(invalidScope));
        ClientDataDto clientData = new ClientDataDto();
        clientData.setDefaultScope(invalidScope);
        this.clientManagement.updateClient(client.getId(), clientData, this.credentials);
    }

    private static void compare(ClientDto client1, ClientDto client2) throws Exception {
        Assert.assertEquals((Object)client1.getId(), (Object)client2.getId());
        Assert.assertEquals((Object)client1.getName(), (Object)client2.getName());
        Assert.assertEquals((Object)client1.getContactAddress(), (Object)client2.getContactAddress());
        Assert.assertEquals((Object)client1.getDescription(), (Object)client2.getDescription());
        Assert.assertEquals((Object)client1.getWebsite(), (Object)client2.getWebsite());
        Assert.assertEquals((Object)client1.getDefaultScope(), (Object)client2.getDefaultScope());
        Assert.assertEquals(new HashSet(client1.getRedirectURIs()), new HashSet(client2.getRedirectURIs()));
        Assert.assertArrayEquals((byte[])client1.getIcon().getData(), (byte[])client2.getIcon().getData());
        Assert.assertEquals((long)client1.getRegistrationDate(), (long)client2.getRegistrationDate());
        Assert.assertEquals((Object)client1.getSecret(), (Object)client2.getSecret());
        Assert.assertEquals((Object)client1.isEnabled(), (Object)client2.isEnabled());
    }

    private static void compare(ClientDataDto clientData, ClientDto client) throws Exception {
        Assert.assertNotNull((Object)client.getId());
        Assert.assertEquals((Object)clientData.getName(), (Object)client.getName());
        Assert.assertEquals((Object)clientData.getContactAddress(), (Object)client.getContactAddress());
        Assert.assertEquals((Object)clientData.getDescription(), (Object)client.getDescription());
        Assert.assertEquals((Object)clientData.getWebsite(), (Object)client.getWebsite());
        Assert.assertEquals((Object)clientData.getDefaultScope(), (Object)client.getDefaultScope().toString());
        Assert.assertEquals(new HashSet(clientData.getRedirectURIs()), new HashSet(client.getRedirectURIs()));
        Assert.assertArrayEquals((byte[])clientData.getIcon().getData(), (byte[])client.getIcon().getData());
        Assert.assertTrue((client.getRegistrationDate() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)client.getSecret());
        Assert.assertTrue((boolean)client.isEnabled());
    }

    public static ClientDataDto prepareClient(String name) {
        IconDto icon = new IconDto();
        icon.setData(IconBytes.DATA);
        icon.setMimeType("image/jpg");
        ArrayList<String> redirectURIs = new ArrayList<String>(2);
        redirectURIs.add("http://localhost");
        redirectURIs.add("http://localhost:8080");
        ClientDataDto clientData = new ClientDataDto();
        clientData.setName(name);
        clientData.setDescription(name);
        clientData.setIcon(icon);
        clientData.setContactAddress("webmaster@example.com");
        clientData.setWebsite("http://www.example.com");
        clientData.setDefaultScope(Scope.newInstance((String[])new String[]{"read_contacts", "write_contacts", "read_calendar", "write_calendar", "read_tasks", "write_tasks"}).toString());
        clientData.setRedirectURIs(redirectURIs);
        return clientData;
    }

    private static final class CMEMatcher
    extends TypeSafeMatcher<RemoteClientManagementException> {
        private final String invalidValue;

        private CMEMatcher(String invalidValue) {
            this.invalidValue = invalidValue;
        }

        protected boolean matchesSafely(RemoteClientManagementException e) {
            String message = e.getMessage();
            return message.contains("Invalid client data") && message.contains(this.invalidValue);
        }

        public void describeTo(Description d) {
            d.appendText(new ClientManagementException(ClientManagementException.Reason.INVALID_CLIENT_DATA, new String[]{this.invalidValue}).getMessage());
        }
    }
}

