/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMailField;
import com.openexchange.ajax.mail.contenttypes.AlternativeStrategy;
import com.openexchange.ajax.mail.contenttypes.FallbackStrategy;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.contenttypes.MailTypeStrategy;
import com.openexchange.ajax.mail.contenttypes.PlainTextStrategy;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.JSON;
import com.openexchange.java.Strings;
import com.openexchange.java.util.TimeZones;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestMail
implements IdentitySource<TestMail> {
    private String from;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;
    private List<JSONObject> attachment;
    private JSONObject headers;
    private String subject;
    private String body;
    private String contentType;
    private String folder;
    private String id;
    private int priority;
    private int flags;
    private int color;
    private List<String> userFlags;
    private final List<MailTypeStrategy> strategies = Arrays.asList(new PlainTextStrategy(), new AlternativeStrategy(), new FallbackStrategy());

    public int getFlags() {
        return this.flags;
    }

    public Object getHeader(String name) {
        if (null == this.headers) {
            return null;
        }
        if (!this.headers.hasAndNotNull(name)) {
            return null;
        }
        return this.headers.opt(name);
    }

    public Set<MailFlag> getFlagsAsSet() {
        return MailFlag.transform(this.flags);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String[] getFolderAndId() {
        return new String[]{this.getFolder(), this.getId()};
    }

    public void setFolderAndID(String[] folderAndID) {
        this.setFolder(folderAndID[0]);
        this.setId(folderAndID[1]);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public List<JSONObject> getAttachment() {
        return this.attachment;
    }

    public List<String> getUserFlags() {
        return this.userFlags;
    }

    public void setAttachment(List<JSONObject> attachment) {
        this.attachment = attachment;
    }

    public TestMail() {
    }

    public TestMail(JSONObject obj) throws JSONException {
        this();
        this.read(obj);
    }

    public TestMail(int[] columns, JSONArray values) throws JSONException {
        this();
        this.read(columns, values);
    }

    public TestMail(Map<String, String> map) throws JSONException {
        this();
        this.read(map);
    }

    public TestMail(String sender, String recipient, String subject, String contentType, String text) throws JSONException {
        this.setFrom(sender);
        this.setTo(Arrays.asList(recipient));
        this.setSubject(subject);
        this.setContentType(contentType);
        this.setBody(text);
        this.sanitize();
    }

    public void read(Map<String, String> map) throws JSONException {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            MailListField field = MailListField.getBy((String)key);
            if (key == null) continue;
            this.setBy(field, (Object)map.get(key));
        }
        this.setBody(map.get(TestMailField.MESSAGE.toString()));
        this.sanitize();
    }

    public void read(JSONObject json) throws JSONException {
        MailJSONField[] values = MailJSONField.values();
        LinkedList<Integer> columns = new LinkedList<Integer>();
        JSONArray jsonArray = new JSONArray();
        for (MailJSONField jsonField : values) {
            MailListField listField = MailListField.getBy((String)jsonField.getKey());
            if (listField == null || !json.has(jsonField.getKey())) continue;
            columns.add(Autoboxing.I((int)listField.getField()));
            jsonArray.put(json.get(jsonField.getKey()));
        }
        this.read(Autoboxing.I2i(columns), jsonArray);
        String field = "user";
        if (json.has(field)) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (Object o : ((JSONArray)json.get(field)).asList()) {
                if (!(o instanceof String)) continue;
                stringList.add((String)o);
            }
            this.setUserFlags(stringList);
        }
        if (json.has(field = "id")) {
            this.setId(json.getString(field));
        }
        if (json.has(field = "folder_id")) {
            this.setFolder(json.getString(field));
        }
        if (json.has(field = MailJSONField.ATTACHMENTS.getKey())) {
            JSONArray array = json.getJSONArray(field);
            this.attachment = new LinkedList<JSONObject>();
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                this.attachment.add(array.getJSONObject(i));
            }
        }
        if (json.has(field = MailJSONField.HEADERS.getKey())) {
            JSONObject hdrObject;
            this.headers = hdrObject = json.getJSONObject(field);
        }
        this.sanitize();
    }

    private void setUserFlags(List<String> flags) {
        this.userFlags = flags;
    }

    public void read(int[] columns, JSONArray values) throws JSONException {
        for (int index = 0; index < columns.length; ++index) {
            MailListField field = MailListField.getField((int)columns[index]);
            if (field == MailListField.FROM) {
                this.setFrom(values.getString(index));
            }
            if (field == MailListField.TO) {
                this.setTo(this.j2l(values.getJSONArray(index)));
            }
            if (field == MailListField.CC) {
                this.setCc(this.j2l(values.getJSONArray(index)));
            }
            if (field == MailListField.BCC) {
                this.setBcc(this.j2l(values.getJSONArray(index)));
            }
            if (field == MailListField.SUBJECT) {
                this.setSubject(values.getString(index));
            }
            if (field == MailListField.ID) {
                this.setId(values.getString(index));
            }
            if (field == MailListField.FOLDER_ID) {
                this.setFolder(values.getString(index));
            }
            if (field == MailListField.COLOR_LABEL) {
                this.setColor(values.getInt(index));
            }
            if (field == MailListField.FLAGS) {
                try {
                    int flags = values.getInt(index);
                    this.setFlags(flags);
                }
                catch (JSONException e) {
                    String flagString = values.getString(index);
                    String[] flags = flagString.split(",");
                    int bitmask = 0;
                    for (String flagName : flags) {
                        MailFlag flag = MailFlag.getByName(flagName);
                        if (flag == null) continue;
                        bitmask += flag.getValue();
                    }
                    this.setFlags(bitmask);
                }
            }
            if (field != MailListField.PRIORITY) continue;
            this.setPriority(values.getInt(index));
        }
        this.sanitize();
    }

    public Object getBy(TestMailField field) {
        if (field == TestMailField.MESSAGE) {
            return this.getBody();
        }
        return null;
    }

    public Object getBy(MailListField field) {
        if (field == MailListField.FROM) {
            return this.getFrom();
        }
        if (field == MailListField.TO) {
            return this.getTo();
        }
        if (field == MailListField.CC) {
            return this.getCc();
        }
        if (field == MailListField.BCC) {
            return this.getBcc();
        }
        if (field == MailListField.SUBJECT) {
            return this.getSubject();
        }
        if (field == MailListField.ID) {
            return this.getId();
        }
        if (field == MailListField.FOLDER) {
            return this.getFolder();
        }
        if (field == MailListField.COLOR_LABEL) {
            return Autoboxing.I((int)this.getColor());
        }
        if (field == MailListField.FLAGS) {
            return Autoboxing.I((int)this.getFlags());
        }
        if (field == MailListField.PRIORITY) {
            return Autoboxing.I((int)this.getPriority());
        }
        return null;
    }

    public void setBy(TestMailField field, Object value) {
        if (field == TestMailField.MESSAGE) {
            this.setBody((String)value);
        }
    }

    public void setBy(MailListField field, Object value) {
        if (field == MailListField.FROM) {
            this.setFrom((String)value);
        }
        if (field == MailListField.TO) {
            this.setTo(this.addresses2list((String)value));
        }
        if (field == MailListField.CC) {
            this.setCc(this.addresses2list((String)value));
        }
        if (field == MailListField.BCC) {
            this.setBcc(this.addresses2list((String)value));
        }
        if (field == MailListField.SUBJECT) {
            this.setSubject((String)value);
        }
        if (field == MailListField.ID) {
            this.setId((String)value);
        }
        if (field == MailListField.FOLDER) {
            this.setFolder((String)value);
        }
        if (field == MailListField.COLOR_LABEL) {
            this.setColor(Integer.valueOf((String)value));
        }
        if (field == MailListField.FLAGS) {
            String myValue = (String)value;
            try {
                this.setFlags(Integer.valueOf(myValue));
            }
            catch (NumberFormatException e) {
                String[] flags = myValue.split(",");
                int bitmask = 0;
                for (String flagName : flags) {
                    MailFlag flag = MailFlag.getByName(flagName);
                    if (flag == null) continue;
                    bitmask += flag.getValue();
                }
                this.setFlags(bitmask);
            }
        }
        if (field == MailListField.PRIORITY) {
            this.setPriority(Integer.valueOf((String)value));
        }
    }

    protected List<String> j2l(JSONArray array) throws JSONException {
        return JSON.jsonArray2list((JSONArray)array);
    }

    protected List<String> addresses2list(String mailAddresses) {
        String[] strings;
        LinkedList<String> addresses = new LinkedList<String>();
        for (String address : strings = mailAddresses.split(",")) {
            addresses.add(address.trim());
        }
        return addresses;
    }

    public void sanitize() throws JSONException {
        for (MailTypeStrategy strategy : this.strategies) {
            if (!strategy.isResponsibleFor(this)) continue;
            strategy.sanitize(this);
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        result.put(MailJSONField.FROM.getKey(), (Object)this.getFrom());
        result.put(MailJSONField.RECIPIENT_TO.getKey(), this.getTo() != null ? this.correctMailAddresses(this.getTo()) : "");
        result.put(MailJSONField.RECIPIENT_BCC.getKey(), this.getBcc() != null ? this.correctMailAddresses(this.getBcc()) : "");
        result.put(MailJSONField.RECIPIENT_CC.getKey(), this.getCc() != null ? this.correctMailAddresses(this.getCc()) : "");
        if (this.getSubject() != null) {
            result.put(MailJSONField.SUBJECT.getKey(), (Object)this.getSubject());
        }
        if (this.getBody() != null) {
            JSONArray attachments = new JSONArray();
            JSONObject jsonbody = new JSONObject();
            jsonbody.put(MailJSONField.CONTENT.getKey(), (Object)this.getBody());
            jsonbody.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)MailContentType.ALTERNATIVE.toString());
            attachments.put((Object)jsonbody);
            result.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
        }
        result.put(MailJSONField.PRIORITY.getKey(), this.getPriority());
        result.put(MailJSONField.CONTENT.getKey(), (Object)(this.getBody() != null ? this.getBody() : ""));
        return result;
    }

    public String toRFC822String() {
        StringBuilder sb = new StringBuilder();
        this.putHeader(sb, "From", this.getFrom());
        this.putHeader(sb, "To", this.getTo());
        this.putHeader(sb, "CC", this.getCc());
        this.putHeader(sb, "BCC", this.getBcc());
        this.putHeader(sb, "Received", "from ox.open-xchange.com;" + DateUtils.toStringRFC822((Date)new Date(), (TimeZone)TimeZones.UTC));
        this.putHeader(sb, "Date", DateUtils.toStringRFC822((Date)new Date(), (TimeZone)TimeZones.UTC));
        this.putHeader(sb, "Subject", this.getSubject());
        String ct = this.getContentType();
        if (ct == null) {
            ct = "text/plain; charset=\"UTF-8\"";
        }
        this.putHeader(sb, "Content-Type", ct);
        this.putHeader(sb, "Content-Transfer-Encoding", "8bit");
        sb.append("\n");
        sb.append(this.getBody());
        return sb.toString();
    }

    private void putHeader(StringBuilder sb, String header, Object value) {
        if (value != null) {
            sb.append(header).append(": ");
            if (value instanceof String) {
                sb.append(value);
            } else if (value instanceof Iterable) {
                boolean first = true;
                for (Object o : (Iterable)value) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(o.toString());
                }
            }
            sb.append("\n");
        }
    }

    public JSONArray correctMailAddresses(List<String> list) {
        JSONArray corrected = new JSONArray();
        for (String recipient : list) {
            JSONArray adress = this.correctMailAdress(recipient);
            corrected.put((Object)adress);
        }
        return corrected;
    }

    public JSONArray correctMailAdress(String recipient) {
        JSONArray corrected = new JSONArray();
        corrected.put((Object)recipient);
        corrected.put((Object)recipient);
        return corrected;
    }

    public String toString() {
        StringBuilder bob = new StringBuilder();
        bob.append("Folder = " + this.getFolder() + ", ID = " + this.getId() + "\n");
        if (this.from != null) {
            bob.append("From: ");
            bob.append(this.from);
        }
        if (this.from != null) {
            bob.append("\nTo: ");
            bob.append(Strings.join(this.to, (String)", "));
        }
        if (this.cc != null) {
            bob.append("\nCC: ");
            bob.append(Strings.join(this.cc, (String)", "));
        }
        if (this.bcc != null) {
            bob.append("\nBCC: ");
            bob.append(Strings.join(this.bcc, (String)", "));
        }
        bob.append("\nPriority: ");
        bob.append(this.getPriority());
        bob.append("\nContent-Type: ");
        bob.append(this.getContentType());
        bob.append("\nSubject: ");
        bob.append(this.getSubject());
        bob.append("\nContent:\n");
        bob.append(this.getBody());
        return bob.toString();
    }

    @Override
    public void assumeIdentity(TestMail entry) {
        entry.setId(this.getId());
        entry.setFolder(this.getFolder());
    }

    @Override
    public void forgetIdentity(TestMail entry) {
    }

    @Override
    public Class<TestMail> getType() {
        return TestMail.class;
    }

    @Override
    public void rememberIdentityValues(TestMail entry) {
        this.setId(entry.getId());
        this.setFolder(entry.getFolder());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestMail other = (TestMail)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

