/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.mail.MailCleaner;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.ArchiveRequest;
import com.openexchange.ajax.mail.actions.CopyRequest;
import com.openexchange.ajax.mail.actions.CopyResponse;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ForwardRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.mail.actions.MailSearchRequest;
import com.openexchange.ajax.mail.actions.MailSearchResponse;
import com.openexchange.ajax.mail.actions.MoveMailRequest;
import com.openexchange.ajax.mail.actions.MoveMailToCategoryRequest;
import com.openexchange.ajax.mail.actions.MoveMailToCategoryResponse;
import com.openexchange.ajax.mail.actions.ReplyAllRequest;
import com.openexchange.ajax.mail.actions.ReplyRequest;
import com.openexchange.ajax.mail.actions.ReplyResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.ajax.mail.actions.TrainRequest;
import com.openexchange.ajax.mail.actions.TrainResponse;
import com.openexchange.ajax.mail.actions.UnreadRequest;
import com.openexchange.ajax.mail.actions.UnreadResponse;
import com.openexchange.ajax.mail.actions.UpdateMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.dataobjects.MailMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class MailTestManager {
    private final List<MailCleaner> cleaningSteps = new LinkedList<MailCleaner>();
    private boolean failOnError;
    private AJAXClient client;
    private AbstractAJAXResponse lastResponse;

    public MailTestManager() {
    }

    public MailTestManager(AJAXClient client) {
        this();
        this.client = client;
    }

    public MailTestManager(AJAXClient client, boolean failOnError) {
        this(client);
        this.failOnError = failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    public void deleteSimilarMails(TestMail mail, AJAXClient client) throws JSONException, OXException, IOException, SAXException {
        LinkedList<String[]> similarMails = this.findSimilarMailsInSameFolder(mail, client);
        DeleteRequest deleteRequest = new DeleteRequest((String[][])similarMails.toArray((T[])new String[0][]));
        this.lastResponse = client.execute(deleteRequest);
    }

    public LinkedList<String[]> findSimilarMailsInSameFolder(TestMail mail, AJAXClient client) throws JSONException, OXException, IOException, SAXException {
        return this.findSimilarMails(mail, client, mail.getFolder());
    }

    public LinkedList<String[]> findSimilarMails(TestMail mail, AJAXClient client, String folder) throws JSONException, OXException, IOException, SAXException {
        JSONArray pattern = new JSONArray();
        JSONObject param = new JSONObject();
        param.put("col", MailListField.SUBJECT.getField());
        param.put("pattern", (Object)mail.getSubject());
        pattern.put((Object)param);
        int[] columns = new int[]{MailListField.ID.getField()};
        MailSearchRequest searchRequest = new MailSearchRequest(pattern, folder, columns, -1, null, false);
        MailSearchResponse searchResponse = client.execute(searchRequest);
        JSONArray ids = searchResponse.getDataAsJSONArray();
        if (null == ids || 0 == ids.length()) {
            return new LinkedList<String[]>();
        }
        LinkedList<String[]> FoldersAndIds = new LinkedList<String[]>();
        int length = ids.length();
        for (int i = 0; i < length; ++i) {
            JSONArray temp = ids.getJSONArray(i);
            FoldersAndIds.add(new String[]{folder, temp.getString(0)});
        }
        return FoldersAndIds;
    }

    public List<TestMail> findAndLoadSimilarMails(TestMail mail, AJAXClient client, String folder) throws JSONException, OXException, IOException, SAXException {
        LinkedList<String[]> mailIDs = this.findSimilarMails(mail, client, folder);
        LinkedList<TestMail> results = new LinkedList<TestMail>();
        for (String[] folderAndId : mailIDs) {
            results.add(this.get(folderAndId));
        }
        return results;
    }

    public TestMail send(TestMail mail) throws JSONException, OXException, IOException, SAXException {
        SendRequest request = new SendRequest(mail.toJSON().toString(), this.failOnError);
        SendResponse response = this.client.execute(request);
        this.lastResponse = response;
        if (this.lastResponse.hasError()) {
            return null;
        }
        String[] folderAndID = response.getFolderAndID();
        mail = this.get(folderAndID[0], folderAndID[1]);
        this.cleaningSteps.add(new MailCleaner(mail, this.client));
        this.markCopyInInboxIfNecessary(mail);
        return mail;
    }

    public TestMail send(TestMail mail, InputStream upload) throws JSONException, OXException, IOException, SAXException {
        SendRequest request = new SendRequest(mail.toJSON().toString(), upload, this.failOnError);
        SendResponse response = this.client.execute(request);
        this.lastResponse = response;
        if (this.lastResponse.hasError()) {
            return null;
        }
        String[] folderAndID = response.getFolderAndID();
        mail = this.get(folderAndID[0], folderAndID[1]);
        this.cleaningSteps.add(new MailCleaner(mail, this.client));
        this.markCopyInInboxIfNecessary(mail);
        return mail;
    }

    public void importMail(TestMail mail) throws OXException, IOException, JSONException {
        String folder = mail.getFolder();
        if (folder == null) {
            folder = "default0/INBOX";
        }
        ByteArrayInputStream mailStream = new ByteArrayInputStream(mail.toRFC822String().getBytes());
        ImportMailRequest request = new ImportMailRequest(folder, 0, true, true, (InputStream[])new ByteArrayInputStream[]{mailStream});
        ImportMailResponse response = this.client.execute(request);
        mail.setFolderAndID(response.getIds()[0]);
    }

    public TestMail move(TestMail mail, String destination) throws OXException, IOException, SAXException, JSONException {
        MoveMailRequest request = new MoveMailRequest(mail.getFolder(), destination, mail.getId(), this.failOnError);
        UpdateMailResponse response = this.client.execute(request);
        this.lastResponse = response;
        if (this.lastResponse.hasError()) {
            return null;
        }
        TestMail modifiedMail = this.get(destination, response.getID());
        this.updateForCleanup(mail, modifiedMail);
        return modifiedMail;
    }

    public void moveToCategory(TestMail mail, String categoryId) throws OXException, IOException, SAXException, JSONException {
        MoveMailToCategoryRequest request = new MoveMailToCategoryRequest(categoryId);
        request.addMail(mail.getId(), mail.getFolder());
        MoveMailToCategoryResponse response = this.client.execute(request);
        this.lastResponse = response;
    }

    public int getUnreadCount(String categoryId) throws Exception {
        UnreadRequest request = new UnreadRequest();
        UnreadResponse response = this.client.execute(request);
        this.lastResponse = response;
        if (this.lastResponse.hasError()) {
            return -1;
        }
        return response.getUnreadCount(categoryId);
    }

    public void trainCategory(String categoryId, boolean applyToExistingOnes, boolean applyToFutureOnes, String ... mails) throws Exception {
        TrainRequest request = new TrainRequest(categoryId, applyToFutureOnes, applyToExistingOnes);
        for (String mail : mails) {
            request.addAddress(mail);
        }
        TrainResponse response = this.client.execute(request);
        this.lastResponse = response;
    }

    public MailMessage[] listMails(String folderPath, int[] columns, int sort, Order order, boolean failOnError, String categoryId) throws Exception {
        AllRequest request = new AllRequest(folderPath, columns, sort, order, failOnError, categoryId);
        AllResponse response = this.client.execute(request);
        this.lastResponse = response;
        return response.getMailMessages(columns);
    }

    public TestMail get(String folder, String id) throws OXException, IOException, SAXException, JSONException {
        GetRequest request = new GetRequest(folder, id, this.failOnError);
        this.lastResponse = this.client.execute(request);
        if (this.lastResponse.hasError()) {
            return null;
        }
        return new TestMail((JSONObject)this.lastResponse.getData());
    }

    public TestMail get(String[] folderAndId) throws OXException, IOException, SAXException, JSONException {
        return this.get(folderAndId[0], folderAndId[1]);
    }

    public TestMail copy(TestMail original, String destination) throws OXException, IOException, SAXException, JSONException {
        CopyRequest request = new CopyRequest(original.getId(), original.getFolder(), destination);
        CopyResponse response = this.client.execute(request);
        String id = response.getID();
        TestMail copy = this.get(destination, id);
        this.cleaningSteps.add(new MailCleaner(copy, this.client));
        this.lastResponse = response;
        return copy;
    }

    public void archive(TestMail original) throws OXException, IOException, JSONException {
        ArchiveRequest archiveRequest = new ArchiveRequest(new String[]{original.getId()}, original.getFolder());
        archiveRequest.setCreateIfAbsent(true);
        archiveRequest.setUseDefaultName(true);
        this.client.execute(archiveRequest);
    }

    public TestMail forwardButDoNotSend(TestMail forwardMe) throws OXException, IOException, SAXException, JSONException {
        ForwardRequest request = new ForwardRequest(forwardMe.getFolderAndId());
        ReplyResponse response = this.client.execute(request);
        TestMail forwarded = new TestMail((JSONObject)response.getData());
        this.lastResponse = response;
        return forwarded;
    }

    public TestMail forwardAndSendBefore(TestMail forwardMe) throws OXException, JSONException, IOException, SAXException {
        TestMail forwarded = this.send(forwardMe);
        TestMail mailFormattedForForwarding = this.forwardButDoNotSend(forwarded);
        this.cleaningSteps.add(new MailCleaner(forwarded, this.client));
        return mailFormattedForForwarding;
    }

    public TestMail replyAndDoNotSend(TestMail replyToMe) throws OXException, IOException, SAXException, JSONException {
        ReplyRequest request = new ReplyRequest(replyToMe.getFolderAndId());
        ReplyResponse response = this.client.execute(request);
        this.lastResponse = response;
        return new TestMail((JSONObject)response.getData());
    }

    public TestMail replyToAllAndDoNotSend(TestMail replyToMe) throws OXException, IOException, SAXException, JSONException {
        ReplyAllRequest request = new ReplyAllRequest(replyToMe.getFolderAndId());
        ReplyResponse response = this.client.execute(request);
        this.lastResponse = response;
        return new TestMail((JSONObject)response.getData());
    }

    public void cleanUp() {
        for (MailCleaner cleanup : this.cleaningSteps) {
            try {
                cleanup.cleanUp();
            }
            catch (Exception e) {
                System.out.println("Could not delete a mail allegedly created. Was probably deleted before.");
                e.printStackTrace();
            }
        }
    }

    protected void updateForCleanup(TestMail originalMail, TestMail modifiedMail) {
        int length = this.cleaningSteps.size();
        for (int i = 0; i < length; ++i) {
            MailCleaner step = this.cleaningSteps.get(i);
            if (!originalMail.equals(step.getMail())) continue;
            step.setMail(modifiedMail);
        }
    }

    protected Set<String> extractAllRecipients(TestMail mail) {
        HashSet<String> recipients = new HashSet<String>();
        if (mail.getFrom() != null) {
            recipients.addAll(mail.getTo());
        }
        if (mail.getCc() != null) {
            recipients.addAll(mail.getCc());
        }
        if (mail.getBcc() != null) {
            recipients.addAll(mail.getBcc());
        }
        return recipients;
    }

    private void markCopyInInboxIfNecessary(TestMail mail) throws OXException, JSONException, IOException, SAXException {
        Set<String> allRecipients = this.extractAllRecipients(mail);
        String sender = this.client.getValues().getSendAddress();
        if (this.containsSomewhat(sender, allRecipients)) {
            LinkedList<String[]> similarMails = this.findSimilarMails(mail, this.client, this.client.getValues().getInboxFolder());
            for (String[] folderAndId : similarMails) {
                TestMail deleteMe = this.get(folderAndId[0], folderAndId[1]);
                this.cleaningSteps.add(new MailCleaner(deleteMe, this.client));
            }
        }
    }

    private boolean containsSomewhat(String needle, Collection<String> haystack) {
        for (String hay : haystack) {
            if (!hay.contains(needle) && !needle.contains(hay)) continue;
            return true;
        }
        return false;
    }

    public TestMail update(String folder, String id, TestMail updates, boolean add) throws OXException, IOException, SAXException, JSONException {
        UpdateMailRequest request = new UpdateMailRequest(folder, id);
        if (updates.getColor() != -1) {
            request.setColor(updates.getColor());
        }
        if (updates.getFlags() != -1) {
            request.setFlags(updates.getFlags());
        }
        if (add) {
            request.doesUpdateFlags();
        } else {
            request.removeFlags();
        }
        UpdateMailResponse response = this.client.execute(request);
        TestMail result = this.get(folder, id);
        this.lastResponse = response;
        return result;
    }
}

